/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.KillUnusedSegments;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class KillUnusedSegmentsTest {
    private static final int MAX_SEGMENTS_TO_KILL = 10;
    private static final Duration COORDINATOR_KILL_PERIOD = Duration.standardMinutes((long)2L);
    private static final Duration DURATION_TO_RETAIN = Duration.standardDays((long)1L);
    private static final Duration INDEXING_PERIOD = Duration.standardMinutes((long)1L);
    @Mock
    private SegmentsMetadataManager segmentsMetadataManager;
    @Mock
    private IndexingServiceClient indexingServiceClient;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private DruidCoordinatorConfig config;
    @Mock
    private DruidCoordinatorRuntimeParams params;
    @Mock
    private CoordinatorDynamicConfig coordinatorDynamicConfig;
    private DataSegment yearOldSegment;
    private DataSegment monthOldSegment;
    private DataSegment dayOldSegment;
    private DataSegment hourOldSegment;
    private DataSegment nextDaySegment;
    private DataSegment nextMonthSegment;
    private KillUnusedSegments target;

    @Before
    public void setup() {
        ((DruidCoordinatorRuntimeParams)Mockito.doReturn((Object)this.coordinatorDynamicConfig).when((Object)this.params)).getCoordinatorDynamicConfig();
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)COORDINATOR_KILL_PERIOD).when((Object)this.config)).getCoordinatorKillPeriod();
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)DURATION_TO_RETAIN).when((Object)this.config)).getCoordinatorKillDurationToRetain();
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)INDEXING_PERIOD).when((Object)this.config)).getCoordinatorIndexingPeriod();
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)10).when((Object)this.config)).getCoordinatorKillMaxSegments();
        ((CoordinatorDynamicConfig)Mockito.doReturn(Collections.singleton("DS1")).when((Object)this.coordinatorDynamicConfig)).getSpecificDataSourcesToKillUnusedSegmentsIn();
        DateTime now = DateTimes.nowUtc();
        this.yearOldSegment = this.createSegmentWithEnd(now.minusDays(365));
        this.monthOldSegment = this.createSegmentWithEnd(now.minusDays(30));
        this.dayOldSegment = this.createSegmentWithEnd(now.minusDays(1));
        this.hourOldSegment = this.createSegmentWithEnd(now.minusHours(1));
        this.nextDaySegment = this.createSegmentWithEnd(now.plusDays(1));
        this.nextMonthSegment = this.createSegmentWithEnd(now.plusDays(30));
        ImmutableList unusedSegments = ImmutableList.of((Object)this.yearOldSegment, (Object)this.monthOldSegment, (Object)this.dayOldSegment, (Object)this.hourOldSegment, (Object)this.nextDaySegment, (Object)this.nextMonthSegment);
        Mockito.when((Object)this.segmentsMetadataManager.getUnusedSegmentIntervals(ArgumentMatchers.anyString(), (DateTime)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenAnswer(arg_0 -> KillUnusedSegmentsTest.lambda$setup$1((List)unusedSegments, arg_0));
        this.target = new KillUnusedSegments(this.segmentsMetadataManager, this.indexingServiceClient, this.config);
    }

    @Test
    public void testRunWithNoIntervalShouldNotKillAnySegments() {
        ((SegmentsMetadataManager)Mockito.doReturn(null).when((Object)this.segmentsMetadataManager)).getUnusedSegmentIntervals(ArgumentMatchers.anyString(), (DateTime)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        this.target.run(this.params);
        ((IndexingServiceClient)Mockito.verify((Object)this.indexingServiceClient, (VerificationMode)Mockito.never())).killUnusedSegments(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Interval)ArgumentMatchers.any(Interval.class));
    }

    @Test
    public void testRunWithSpecificDatasourceAndNoIntervalShouldNotKillAnySegments() {
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)Duration.standardDays((long)400L)).when((Object)this.config)).getCoordinatorKillDurationToRetain();
        this.target = new KillUnusedSegments(this.segmentsMetadataManager, this.indexingServiceClient, this.config);
        this.target.run(this.params);
        ((IndexingServiceClient)Mockito.verify((Object)this.indexingServiceClient, (VerificationMode)Mockito.never())).killUnusedSegments(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Interval)ArgumentMatchers.any(Interval.class));
    }

    @Test
    public void testDurationToRetain() {
        Interval expectedKillInterval = new Interval((ReadableInstant)this.yearOldSegment.getInterval().getStart(), (ReadableInstant)this.dayOldSegment.getInterval().getEnd());
        this.runAndVerifyKillInterval(expectedKillInterval);
    }

    @Test
    public void testNegativeDurationToRetain() {
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)DURATION_TO_RETAIN.negated()).when((Object)this.config)).getCoordinatorKillDurationToRetain();
        this.target = new KillUnusedSegments(this.segmentsMetadataManager, this.indexingServiceClient, this.config);
        Interval expectedKillInterval = new Interval((ReadableInstant)this.yearOldSegment.getInterval().getStart(), (ReadableInstant)this.nextDaySegment.getInterval().getEnd());
        this.runAndVerifyKillInterval(expectedKillInterval);
    }

    @Test
    public void testIgnoreDurationToRetain() {
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)true).when((Object)this.config)).getCoordinatorKillIgnoreDurationToRetain();
        this.target = new KillUnusedSegments(this.segmentsMetadataManager, this.indexingServiceClient, this.config);
        Interval expectedKillInterval = new Interval((ReadableInstant)this.yearOldSegment.getInterval().getStart(), (ReadableInstant)this.nextMonthSegment.getInterval().getEnd());
        this.runAndVerifyKillInterval(expectedKillInterval);
    }

    @Test
    public void testMaxSegmentsToKill() {
        ((DruidCoordinatorConfig)Mockito.doReturn((Object)1).when((Object)this.config)).getCoordinatorKillMaxSegments();
        this.target = new KillUnusedSegments(this.segmentsMetadataManager, this.indexingServiceClient, this.config);
        this.runAndVerifyKillInterval(this.yearOldSegment.getInterval());
    }

    private void runAndVerifyKillInterval(Interval expectedKillInterval) {
        this.target.run(this.params);
        ((IndexingServiceClient)Mockito.verify((Object)this.indexingServiceClient, (VerificationMode)Mockito.times((int)1))).killUnusedSegments(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"DS1"), (Interval)ArgumentMatchers.eq((Object)expectedKillInterval));
    }

    private DataSegment createSegmentWithEnd(DateTime endTime) {
        return new DataSegment("DS1", new Interval((ReadablePeriod)Period.days((int)1), (ReadableInstant)endTime), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(1), 0L);
    }

    private static /* synthetic */ Object lambda$setup$1(List unusedSegments, InvocationOnMock invocation) throws Throwable {
        DateTime maxEndTime = (DateTime)invocation.getArgument(1);
        long maxEndMillis = maxEndTime.getMillis();
        List unusedIntervals = unusedSegments.stream().map(DataSegment::getInterval).filter(i -> i.getEnd().getMillis() <= maxEndMillis).collect(Collectors.toList());
        int limit = (Integer)invocation.getArgument(2);
        return unusedIntervals.size() <= limit ? unusedIntervals : unusedIntervals.subList(0, limit);
    }
}

