/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.druid.server.coordinator.rules.Rule;

public class TestMetadataRuleManager
implements MetadataRuleManager {
    private final Map<String, List<Rule>> rules = new HashMap<String, List<Rule>>();
    private static final String DEFAULT_DATASOURCE = "_default";

    public TestMetadataRuleManager() {
        this.rules.put(DEFAULT_DATASOURCE, Collections.singletonList(new ForeverLoadRule(null)));
    }

    public void start() {
    }

    public void stop() {
    }

    public void poll() {
    }

    public Map<String, List<Rule>> getAllRules() {
        return this.rules;
    }

    public List<Rule> getRules(String dataSource) {
        ArrayList retVal = this.rules.get(dataSource);
        return retVal == null ? new ArrayList() : retVal;
    }

    public List<Rule> getRulesWithDefault(String dataSource) {
        ArrayList<Rule> retVal = new ArrayList<Rule>();
        Map<String, List<Rule>> theRules = this.rules;
        if (theRules.get(dataSource) != null) {
            retVal.addAll((Collection)theRules.get(dataSource));
        }
        if (theRules.get(DEFAULT_DATASOURCE) != null) {
            retVal.addAll((Collection<Rule>)theRules.get(DEFAULT_DATASOURCE));
        }
        return retVal;
    }

    public boolean overrideRule(String dataSource, List<Rule> newRules, AuditInfo auditInfo) {
        this.rules.put(dataSource, newRules);
        return true;
    }

    public int removeRulesForEmptyDatasourcesOlderThan(long timestamp) {
        return 0;
    }

    public void removeRulesForDatasource(String dataSource) {
        if (!DEFAULT_DATASOURCE.equals(dataSource)) {
            this.rules.remove(dataSource);
        }
    }
}

