/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class TestSegmentsMetadataManager
implements SegmentsMetadataManager {
    private final ConcurrentMap<String, DataSegment> segments = new ConcurrentHashMap<String, DataSegment>();
    private final ConcurrentMap<String, DataSegment> usedSegments = new ConcurrentHashMap<String, DataSegment>();

    public void addSegment(DataSegment segment) {
        this.segments.put(segment.getId().toString(), segment);
        this.usedSegments.put(segment.getId().toString(), segment);
    }

    public void removeSegment(DataSegment segment) {
        this.segments.remove(segment.getId().toString());
        this.usedSegments.remove(segment.getId().toString());
    }

    public void startPollingDatabasePeriodically() {
    }

    public void stopPollingDatabasePeriodically() {
    }

    public boolean isPollingDatabasePeriodically() {
        return true;
    }

    public int markAsUsedAllNonOvershadowedSegmentsInDataSource(String dataSource) {
        return 0;
    }

    public int markAsUsedNonOvershadowedSegmentsInInterval(String dataSource, Interval interval) {
        return 0;
    }

    public int markAsUsedNonOvershadowedSegments(String dataSource, Set<String> segmentIds) {
        return 0;
    }

    public boolean markSegmentAsUsed(String segmentId) {
        if (!this.segments.containsKey(segmentId)) {
            return false;
        }
        this.usedSegments.put(segmentId, (DataSegment)this.segments.get(segmentId));
        return true;
    }

    public int markAsUnusedAllSegmentsInDataSource(String dataSource) {
        return 0;
    }

    public int markAsUnusedSegmentsInInterval(String dataSource, Interval interval) {
        return 0;
    }

    public int markSegmentsAsUnused(Set<SegmentId> segmentIds) {
        int numModifiedSegments = 0;
        for (SegmentId segmentId : segmentIds) {
            if (this.usedSegments.remove(segmentId.toString()) == null) continue;
            ++numModifiedSegments;
        }
        return numModifiedSegments;
    }

    public boolean markSegmentAsUnused(SegmentId segmentId) {
        return this.usedSegments.remove(segmentId.toString()) != null;
    }

    @Nullable
    public ImmutableDruidDataSource getImmutableDataSourceWithUsedSegments(String dataSource) {
        return null;
    }

    public Collection<ImmutableDruidDataSource> getImmutableDataSourcesWithAllUsedSegments() {
        return this.getSnapshotOfDataSourcesWithAllUsedSegments().getDataSourcesWithAllUsedSegments();
    }

    public DataSourcesSnapshot getSnapshotOfDataSourcesWithAllUsedSegments() {
        return DataSourcesSnapshot.fromUsedSegments(this.usedSegments.values(), (ImmutableMap)ImmutableMap.of());
    }

    public Iterable<DataSegment> iterateAllUsedSegments() {
        return this.usedSegments.values();
    }

    public Optional<Iterable<DataSegment>> iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(String datasource, Interval interval, boolean requiresLatest) {
        VersionedIntervalTimeline usedSegmentsTimeline = (VersionedIntervalTimeline)this.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource().get(datasource);
        return Optional.fromNullable((Object)usedSegmentsTimeline).transform(timeline -> timeline.findNonOvershadowedObjectsInInterval(interval, Partitions.ONLY_COMPLETE));
    }

    public Set<String> retrieveAllDataSourceNames() {
        return null;
    }

    public List<Interval> getUnusedSegmentIntervals(String dataSource, DateTime maxEndTime, int limit) {
        return null;
    }

    public void poll() {
    }
}

