/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.metrics.TaskCountStatsMonitor;
import org.apache.druid.server.metrics.TaskCountStatsProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskCountStatsMonitorTest {
    private TaskCountStatsProvider statsProvider;

    @Before
    public void setUp() {
        this.statsProvider = new TaskCountStatsProvider(){

            public Map<String, Long> getSuccessfulTaskCount() {
                return ImmutableMap.of((Object)"d1", (Object)1L);
            }

            public Map<String, Long> getFailedTaskCount() {
                return ImmutableMap.of((Object)"d1", (Object)1L);
            }

            public Map<String, Long> getRunningTaskCount() {
                return ImmutableMap.of((Object)"d1", (Object)1L);
            }

            public Map<String, Long> getPendingTaskCount() {
                return ImmutableMap.of((Object)"d1", (Object)1L);
            }

            public Map<String, Long> getWaitingTaskCount() {
                return ImmutableMap.of((Object)"d1", (Object)1L);
            }
        };
    }

    @Test
    public void testMonitor() {
        TaskCountStatsMonitor monitor = new TaskCountStatsMonitor(this.statsProvider);
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)5L, (long)emitter.getEvents().size());
        emitter.verifyValue("task/success/count", (Number)1L);
        emitter.verifyValue("task/failed/count", (Number)1L);
        emitter.verifyValue("task/running/count", (Number)1L);
        emitter.verifyValue("task/pending/count", (Number)1L);
        emitter.verifyValue("task/waiting/count", (Number)1L);
    }
}

