/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Map;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.ModelProperties;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.ResolvedExternalTable;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;

public class ExternalTableDefn
extends TableDefn {
    public static final String TABLE_TYPE = "extern";
    public static final String SOURCE_PROPERTY = "source";
    public static final String FORMAT_PROPERTY = "format";
    private static final ModelProperties.PropertyDefn<InputSource> SOURCE_PROPERTY_DEFN = new ModelProperties.ObjectPropertyDefn<InputSource>("source", InputSource.class);
    private static final ModelProperties.PropertyDefn<InputFormat> FORMAT_PROPERTY_DEFN = new ModelProperties.ObjectPropertyDefn<InputFormat>("format", InputFormat.class);
    @VisibleForTesting
    public static final TypeReference<Map<String, Object>> MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    private TableDefnRegistry registry;

    public ExternalTableDefn() {
        super("External table", TABLE_TYPE, Arrays.asList(SOURCE_PROPERTY_DEFN, FORMAT_PROPERTY_DEFN), null);
    }

    @Override
    public void bind(TableDefnRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void validate(ResolvedTable table) {
        for (ModelProperties.PropertyDefn<?> propDefn : this.properties().values()) {
            if (propDefn == SOURCE_PROPERTY_DEFN || propDefn == FORMAT_PROPERTY_DEFN) continue;
            propDefn.validate(table.property(propDefn.name()), table.jsonMapper());
        }
        this.validateColumns(table.spec().columns());
        new ResolvedExternalTable(table).validate(this.registry);
    }

    public TableFunction tableFn(ResolvedTable table) {
        return new ResolvedExternalTable(table).resolve(this.registry).tableFn();
    }

    @Override
    protected void validateColumn(ColumnSpec colSpec) {
    }

    public ExternalTableSpec convert(ResolvedTable table) {
        return new ResolvedExternalTable(table).resolve(this.registry).convert();
    }

    public static boolean isExternalTable(ResolvedTable table) {
        return TABLE_TYPE.equals(table.spec().type());
    }
}

