/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.table.BaseInputSourceDefn;
import org.apache.druid.catalog.model.table.BaseTableFunction;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.InputFormatDefn;
import org.apache.druid.catalog.model.table.ResolvedExternalTable;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.utils.CollectionUtils;

public abstract class FormattedInputSourceDefn
extends BaseInputSourceDefn {
    public static final String FORMAT_PARAMETER = "format";
    private Map<String, InputFormatDefn> formats;

    @Override
    public void bind(TableDefnRegistry registry) {
        this.formats = registry.formats();
        super.bind(registry);
    }

    @Override
    public void validate(ResolvedExternalTable table) {
        boolean hasFormat;
        boolean hasColumns = !CollectionUtils.isNullOrEmpty(table.resolvedTable().spec().columns());
        boolean bl = hasFormat = table.inputFormatMap != null;
        if (hasColumns && !hasFormat) {
            throw new IAE("If an external table provides columns, it must also provide a format", new Object[0]);
        }
        if (!hasColumns && hasFormat) {
            throw new IAE("If an external table provides a format, it must also provide columns", new Object[0]);
        }
        super.validate(table);
    }

    @Override
    protected BaseInputSourceDefn.AdHocTableFunction defineAdHocTableFunction() {
        List<TableFunction.ParameterDefn> fullTableParams = this.adHocTableFnParameters();
        List<TableFunction.ParameterDefn> allParams = this.addFormatParameters(fullTableParams);
        return new BaseInputSourceDefn.AdHocTableFunction(this, allParams);
    }

    protected abstract List<TableFunction.ParameterDefn> adHocTableFnParameters();

    protected List<TableFunction.ParameterDefn> addFormatParameters(List<TableFunction.ParameterDefn> properties) {
        ArrayList<TableFunction.ParameterDefn> toAdd = new ArrayList<TableFunction.ParameterDefn>();
        BaseTableFunction.Parameter formatProp = new BaseTableFunction.Parameter(FORMAT_PARAMETER, TableFunction.ParameterType.VARCHAR, true);
        toAdd.add(formatProp);
        HashMap<String, TableFunction.ParameterDefn> formatProps = new HashMap<String, TableFunction.ParameterDefn>();
        for (InputFormatDefn format : this.formats.values()) {
            for (TableFunction.ParameterDefn prop : format.parameters()) {
                TableFunction.ParameterDefn existing = formatProps.putIfAbsent(prop.name(), prop);
                if (existing == null) {
                    toAdd.add(prop);
                    continue;
                }
                if (existing.type() == prop.type()) continue;
                throw new ISE("Format %s, property %s of class %s conflicts with another format property of class %s", new Object[]{format.typeValue(), prop.name(), prop.type().sqlName(), existing.type().sqlName()});
            }
        }
        return CatalogUtils.concatLists(properties, toAdd);
    }

    @Override
    protected InputFormat convertTableToFormat(ResolvedExternalTable table) {
        String formatTag = CatalogUtils.getString(table.inputFormatMap, "type");
        if (formatTag == null) {
            throw new IAE("[%s] property must be provided", new Object[]{"type"});
        }
        InputFormatDefn formatDefn = this.formats.get(formatTag);
        if (formatDefn == null) {
            throw new IAE("Format type [%s] for property %s is not valid", new Object[]{formatTag, "type"});
        }
        return formatDefn.convertFromTable(table);
    }

    @Override
    protected InputFormat convertArgsToFormat(Map<String, Object> args, List<ColumnSpec> columns, ObjectMapper jsonMapper) {
        String formatTag = CatalogUtils.getString(args, FORMAT_PARAMETER);
        if (formatTag == null) {
            throw new IAE("Must provide a value for the [%s] parameter", new Object[]{FORMAT_PARAMETER});
        }
        InputFormatDefn formatDefn = this.formats.get(formatTag);
        if (formatDefn == null) {
            throw new IAE("Format type [%s] for property [%s] is not valid", new Object[]{formatTag, FORMAT_PARAMETER});
        }
        return formatDefn.convertFromArgs(args, columns, jsonMapper);
    }

    protected ExternalTableSpec convertPartialFormattedTable(ResolvedExternalTable table, Map<String, Object> args, List<ColumnSpec> columns, Map<String, Object> sourceMap) {
        ObjectMapper jsonMapper = table.resolvedTable().jsonMapper();
        List<ColumnSpec> completedCols = this.selectPartialTableColumns(table, columns);
        InputFormat inputFormat = table.inputFormatMap == null ? this.convertArgsToFormat(args, completedCols, jsonMapper) : this.convertTableToFormat(table);
        return new ExternalTableSpec(this.convertSource(sourceMap, jsonMapper), inputFormat, Columns.convertSignature(completedCols), (Supplier<Set<String>>)((Supplier)() -> Collections.singleton(this.typeValue())));
    }
}

