/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.table.BaseInputSourceDefn;
import org.apache.druid.catalog.model.table.BaseTableFunction;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.FormattedInputSourceDefn;
import org.apache.druid.catalog.model.table.ResolvedExternalTable;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.HttpInputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.utils.CollectionUtils;

public class HttpInputSourceDefn
extends FormattedInputSourceDefn {
    public static final String TYPE_KEY = "http";
    public static final String URI_TEMPLATE_PROPERTY = "uriTemplate";
    public static final String URIS_PARAMETER = "uris";
    public static final String USER_PARAMETER = "userName";
    public static final String PASSWORD_PARAMETER = "password";
    public static final String PASSWORD_ENV_VAR_PARAMETER = "passwordEnvVar";
    private static final List<TableFunction.ParameterDefn> URI_PARAMS = Collections.singletonList(new BaseTableFunction.Parameter("uris", TableFunction.ParameterType.VARCHAR_ARRAY, true));
    private static final List<TableFunction.ParameterDefn> USER_PWD_PARAMS = Arrays.asList(new BaseTableFunction.Parameter("userName", TableFunction.ParameterType.VARCHAR, true), new BaseTableFunction.Parameter("password", TableFunction.ParameterType.VARCHAR, true), new BaseTableFunction.Parameter("passwordEnvVar", TableFunction.ParameterType.VARCHAR, true));
    protected static final String URIS_FIELD = "uris";
    protected static final String PASSWORD_FIELD = "httpAuthenticationPassword";
    protected static final String USERNAME_FIELD = "httpAuthenticationUsername";

    @Override
    public String typeValue() {
        return TYPE_KEY;
    }

    @Override
    protected Class<? extends InputSource> inputSourceClass() {
        return HttpInputSource.class;
    }

    @Override
    public void validate(ResolvedExternalTable table) {
        boolean hasColumns;
        Map<String, Object> sourceMap = table.inputSourceMap;
        boolean hasUri = sourceMap.containsKey("uris");
        String uriTemplate = table.resolvedTable().stringProperty(URI_TEMPLATE_PROPERTY);
        boolean hasTemplate = uriTemplate != null;
        boolean hasFormat = table.inputFormatMap != null;
        boolean bl = hasColumns = !CollectionUtils.isNullOrEmpty(table.resolvedTable().spec().columns());
        if (!hasUri && !hasTemplate) {
            throw new IAE("External HTTP tables must provide either a URI or a %s property", new Object[]{URI_TEMPLATE_PROPERTY});
        }
        if (hasUri && hasTemplate) {
            throw new IAE("External HTTP tables must provide only one of a URI or a %s property", new Object[]{URI_TEMPLATE_PROPERTY});
        }
        if (hasUri && !hasFormat) {
            throw new IAE("An external HTTP table with a URI must also provide the corresponding format", new Object[0]);
        }
        if (hasUri && !hasColumns) {
            throw new IAE("An external HTTP table with a URI must also provide the corresponding columns", new Object[0]);
        }
        if (hasTemplate) {
            this.templateMatcher(uriTemplate);
            try {
                sourceMap.put("uris", Collections.singletonList(new URI("https://bogus.com/file")));
            }
            catch (Exception e) {
                throw new ISE((Throwable)e, "URI parse failed", new Object[0]);
            }
        }
        super.validate(table);
    }

    @Override
    protected void auditInputSource(Map<String, Object> jsonMap) {
        jsonMap.putIfAbsent("uris", "http://bogus.com");
    }

    private Matcher templateMatcher(String uriTemplate) {
        Pattern p = Pattern.compile("\\{}");
        Matcher m = p.matcher(uriTemplate);
        if (!m.find()) {
            throw new IAE("Value [%s] for property %s must include a '{}' placeholder", new Object[]{uriTemplate, URI_TEMPLATE_PROPERTY});
        }
        return m;
    }

    @Override
    protected List<TableFunction.ParameterDefn> adHocTableFnParameters() {
        return CatalogUtils.concatLists(URI_PARAMS, USER_PWD_PARAMS);
    }

    @Override
    protected void convertArgsToSourceMap(Map<String, Object> jsonMap, Map<String, Object> args) {
        jsonMap.put("type", TYPE_KEY);
        this.convertUriArg(jsonMap, args);
        this.convertUserPasswordArgs(jsonMap, args);
    }

    @Override
    public TableFunction partialTableFn(ResolvedExternalTable table) {
        List<TableFunction.ParameterDefn> params = Collections.emptyList();
        Map<String, Object> sourceMap = table.inputSourceMap;
        if (!sourceMap.containsKey("uris")) {
            params = CatalogUtils.concatLists(params, URI_PARAMS);
        }
        if (!sourceMap.containsKey(USERNAME_FIELD) && !sourceMap.containsKey(PASSWORD_FIELD)) {
            params = CatalogUtils.concatLists(params, USER_PWD_PARAMS);
        }
        if (table.inputFormatMap == null) {
            params = this.addFormatParameters(params);
        }
        return new BaseInputSourceDefn.PartialTableFunction(this, table, params);
    }

    @Override
    protected ExternalTableSpec convertCompletedTable(ResolvedExternalTable table, Map<String, Object> args, List<ColumnSpec> columns) {
        HashMap<String, Object> sourceMap = new HashMap<String, Object>(table.inputSourceMap);
        String uriTemplate = table.resolvedTable().stringProperty(URI_TEMPLATE_PROPERTY);
        if (uriTemplate != null) {
            this.convertUriTemplateArgs(sourceMap, uriTemplate, args);
        } else if (!sourceMap.containsKey("uris")) {
            this.convertUriArg(sourceMap, args);
        }
        if (!sourceMap.containsKey(USERNAME_FIELD) && !sourceMap.containsKey(PASSWORD_FIELD)) {
            this.convertUserPasswordArgs(sourceMap, args);
        }
        return this.convertPartialFormattedTable(table, args, columns, sourceMap);
    }

    private void convertUriTemplateArgs(Map<String, Object> jsonMap, String uriTemplate, Map<String, Object> args) {
        List<String> uriStrings = CatalogUtils.getStringArray(args, "uris");
        if (CollectionUtils.isNullOrEmpty(uriStrings)) {
            throw new IAE("One or more URIs is required in parameter %s", new Object[]{"uris"});
        }
        Matcher m = this.templateMatcher(uriTemplate);
        List<String> uris = uriStrings.stream().map(uri -> m.replaceFirst((String)uri)).collect(Collectors.toList());
        jsonMap.put("uris", CatalogUtils.stringListToUriList(uris));
    }

    private void convertUriArg(Map<String, Object> jsonMap, Map<String, Object> args) {
        List<String> uris = CatalogUtils.getStringArray(args, "uris");
        if (uris != null) {
            jsonMap.put("uris", CatalogUtils.stringListToUriList(uris));
        }
    }

    private void convertUserPasswordArgs(Map<String, Object> jsonMap, Map<String, Object> args) {
        String user = CatalogUtils.getString(args, USER_PARAMETER);
        if (user != null) {
            jsonMap.put(USERNAME_FIELD, user);
        }
        String password = CatalogUtils.getString(args, PASSWORD_PARAMETER);
        String passwordEnvVar = CatalogUtils.getString(args, PASSWORD_ENV_VAR_PARAMETER);
        if (password != null && passwordEnvVar != null) {
            throw new ISE("Specify only one of %s or %s", new Object[]{PASSWORD_PARAMETER, PASSWORD_ENV_VAR_PARAMETER});
        }
        if (password != null) {
            jsonMap.put(PASSWORD_FIELD, ImmutableMap.of((Object)"type", (Object)"default", (Object)PASSWORD_PARAMETER, (Object)password));
        } else if (passwordEnvVar != null) {
            jsonMap.put(PASSWORD_FIELD, ImmutableMap.of((Object)"type", (Object)"environment", (Object)"variable", (Object)passwordEnvVar));
        }
    }
}

