/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.table.BaseInputSourceDefn;
import org.apache.druid.catalog.model.table.BaseTableFunction;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.FormattedInputSourceDefn;
import org.apache.druid.catalog.model.table.ResolvedExternalTable;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.utils.CollectionUtils;

public class LocalInputSourceDefn
extends FormattedInputSourceDefn {
    public static final String TYPE_KEY = "local";
    public static final String BASE_DIR_PARAMETER = "baseDir";
    public static final String FILTER_PARAMETER = "filter";
    public static final String FILES_PARAMETER = "files";
    protected static final String BASE_DIR_FIELD = "baseDir";
    protected static final String FILES_FIELD = "files";
    protected static final String FILTER_FIELD = "filter";
    private static final TableFunction.ParameterDefn FILTER_PARAM_DEFN = new BaseTableFunction.Parameter("filter", TableFunction.ParameterType.VARCHAR, true);
    private static final TableFunction.ParameterDefn FILES_PARAM_DEFN = new BaseTableFunction.Parameter("files", TableFunction.ParameterType.VARCHAR_ARRAY, true);

    @Override
    public String typeValue() {
        return TYPE_KEY;
    }

    @Override
    protected Class<? extends InputSource> inputSourceClass() {
        return LocalInputSource.class;
    }

    @Override
    public void validate(ResolvedExternalTable table) {
        boolean hasFilter;
        HashMap<String, Object> sourceMap = new HashMap<String, Object>(table.inputSourceMap);
        boolean hasBaseDir = sourceMap.containsKey("baseDir");
        boolean hasFiles = !CollectionUtils.isNullOrEmpty((Collection)CatalogUtils.safeGet(sourceMap, "files", List.class));
        boolean bl = hasFilter = !Strings.isNullOrEmpty((String)CatalogUtils.getString(sourceMap, "filter"));
        if (!hasBaseDir && !hasFiles) {
            throw new IAE("A local input source requires one property of %s or %s", new Object[]{"baseDir", "files"});
        }
        if (!hasBaseDir && hasFilter) {
            throw new IAE("If a local input source sets property %s, it must also set property %s", new Object[]{"filter", "baseDir"});
        }
        if (hasBaseDir && hasFiles) {
            throw new IAE("A local input source accepts only one of %s or %s", new Object[]{"baseDir", "files"});
        }
        super.validate(table);
    }

    @Override
    protected List<TableFunction.ParameterDefn> adHocTableFnParameters() {
        return Arrays.asList(new BaseTableFunction.Parameter("baseDir", TableFunction.ParameterType.VARCHAR, true), FILTER_PARAM_DEFN, FILES_PARAM_DEFN);
    }

    @Override
    protected void convertArgsToSourceMap(Map<String, Object> jsonMap, Map<String, Object> args) {
        boolean hasFilter;
        jsonMap.put("type", TYPE_KEY);
        String baseDirParam = CatalogUtils.getString(args, "baseDir");
        List<String> filesParam = CatalogUtils.getStringArray(args, "files");
        String filterParam = CatalogUtils.getString(args, "filter");
        boolean hasBaseDir = !Strings.isNullOrEmpty((String)baseDirParam);
        boolean hasFiles = !CollectionUtils.isNullOrEmpty(filesParam);
        boolean bl = hasFilter = !Strings.isNullOrEmpty((String)filterParam);
        if (!hasBaseDir && !hasFiles) {
            throw new IAE("A local input source requires one parameter of %s or %s", new Object[]{"baseDir", "files"});
        }
        if (hasBaseDir && hasFiles) {
            if (hasFilter) {
                throw new IAE("A local input source can set parameter %s or %s, but not both.", new Object[]{"files", "filter"});
            }
            jsonMap.put("files", this.absolutePath(baseDirParam, filesParam));
            return;
        }
        if (!hasBaseDir && !Strings.isNullOrEmpty((String)filterParam)) {
            throw new IAE("If a local input source sets parameter %s, it must also set parameter %s", new Object[]{"filter", "baseDir"});
        }
        if (hasBaseDir) {
            jsonMap.put("baseDir", baseDirParam);
        }
        if (hasFiles) {
            jsonMap.put("files", filesParam);
        }
        if (filterParam != null) {
            jsonMap.put("filter", filterParam);
        }
    }

    private List<String> absolutePath(String baseDirPath, List<String> files) {
        File baseDir = new File(baseDirPath);
        return files.stream().map(f -> new File(baseDir, (String)f).toString()).collect(Collectors.toList());
    }

    @Override
    public TableFunction partialTableFn(ResolvedExternalTable table) {
        HashMap<String, Object> sourceMap = new HashMap<String, Object>(table.inputSourceMap);
        boolean hasBaseDir = !Strings.isNullOrEmpty((String)CatalogUtils.getString(sourceMap, "baseDir"));
        boolean hasFiles = !CollectionUtils.isNullOrEmpty((Collection)CatalogUtils.safeGet(sourceMap, "files", List.class));
        boolean hasFilter = !Strings.isNullOrEmpty((String)CatalogUtils.getString(sourceMap, "filter"));
        List<TableFunction.ParameterDefn> params = new ArrayList<TableFunction.ParameterDefn>();
        if (hasBaseDir && !hasFiles && !hasFilter) {
            params.add(FILES_PARAM_DEFN);
            params.add(FILTER_PARAM_DEFN);
        }
        if (table.inputFormatMap == null) {
            params = this.addFormatParameters(params);
        }
        return new BaseInputSourceDefn.PartialTableFunction(this, table, params);
    }

    @Override
    protected ExternalTableSpec convertCompletedTable(ResolvedExternalTable table, Map<String, Object> args, List<ColumnSpec> columns) {
        boolean hasFiles;
        HashMap<String, Object> sourceMap = new HashMap<String, Object>(table.inputSourceMap);
        boolean bl = hasFiles = !CollectionUtils.isNullOrEmpty((Collection)CatalogUtils.safeGet(sourceMap, "files", List.class));
        if (hasFiles) {
            if (!args.isEmpty()) {
                throw new IAE("The local input source has a file list: do not provide other arguments", new Object[0]);
            }
        } else {
            boolean hasFilterParam;
            String baseDir = CatalogUtils.getString(sourceMap, "baseDir");
            if (Strings.isNullOrEmpty((String)baseDir)) {
                throw new IAE("When a local external table is used with a table function, %s must be set", new Object[]{"baseDir"});
            }
            boolean hasFilter = !Strings.isNullOrEmpty((String)CatalogUtils.getString(sourceMap, "filter"));
            List<String> filesParam = CatalogUtils.getStringArray(args, "files");
            boolean hasFilesParam = !CollectionUtils.isNullOrEmpty(filesParam);
            String filterParam = CatalogUtils.getString(args, "filter");
            boolean bl2 = hasFilterParam = !Strings.isNullOrEmpty((String)filterParam);
            if (!(hasFilter || hasFilesParam || hasFilterParam)) {
                throw new IAE("For a local input source, set either %s or %s", new Object[]{"files", "filter"});
            }
            if (hasFilesParam) {
                sourceMap.remove("filter");
                sourceMap.remove("baseDir");
                sourceMap.put("files", this.absolutePath(baseDir, filesParam));
            } else if (filterParam != null) {
                sourceMap.put("filter", filterParam);
            }
        }
        return this.convertPartialFormattedTable(table, args, columns, sourceMap);
    }

    @Override
    protected void auditInputSource(Map<String, Object> jsonMap) {
        String filter = CatalogUtils.getString(jsonMap, "filter");
        if (filter != null) {
            return;
        }
        String baseDir = CatalogUtils.getString(jsonMap, "baseDir");
        if (baseDir != null) {
            jsonMap.put("filter", "*");
        }
    }

    @Override
    public ExternalTableSpec convertTable(ResolvedExternalTable table) {
        boolean hasFilter;
        HashMap<String, Object> sourceMap = new HashMap<String, Object>(table.inputSourceMap);
        boolean hasFiles = !CollectionUtils.isNullOrEmpty((Collection)CatalogUtils.safeGet(sourceMap, "files", List.class));
        boolean bl = hasFilter = !Strings.isNullOrEmpty((String)CatalogUtils.getString(sourceMap, "filter"));
        if (!hasFiles && !hasFilter) {
            throw new IAE("Use a table function to set either %s or %s", new Object[]{"files", "filter"});
        }
        return super.convertTable(table);
    }
}

