/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.TableSpec;
import org.apache.druid.catalog.model.table.ClusterKeySpec;
import org.apache.druid.java.util.common.IAE;

public class TableBuilder {
    private final TableId id;
    private final String tableType;
    private TableDefn defn;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private List<ColumnSpec> columns = new ArrayList<ColumnSpec>();

    public TableBuilder(TableId id, String tableType) {
        this.id = id;
        this.tableType = tableType;
    }

    public static TableBuilder datasource(String name, String granularity) {
        return new TableBuilder(TableId.datasource(name), "datasource").segmentGranularity(granularity);
    }

    public static TableBuilder external(String name) {
        return new TableBuilder(TableId.of("ext", name), "extern");
    }

    public static TableBuilder updateFor(TableMetadata table) {
        return new TableBuilder(table.id(), table.spec().type());
    }

    public static TableBuilder copyOf(TableMetadata table) {
        return TableBuilder.copyOf(table.id(), table.spec());
    }

    public static TableBuilder copyOf(TableId newId, TableSpec from) {
        return new TableBuilder(newId, from.type()).properties(new HashMap<String, Object>(from.properties())).columns(new ArrayList<ColumnSpec>(from.columns()));
    }

    public static TableBuilder of(TableId id, TableDefn defn) {
        TableBuilder builder = new TableBuilder(id, defn.typeValue());
        builder.defn = defn;
        return builder;
    }

    public TableBuilder copy() {
        TableBuilder builder = new TableBuilder(this.id, this.tableType);
        builder.defn = this.defn;
        builder.properties.putAll(this.properties);
        builder.columns.addAll(this.columns);
        return builder;
    }

    public TableBuilder properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public TableBuilder property(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public TableBuilder description(String description) {
        return this.property("description", description);
    }

    public TableBuilder segmentGranularity(String segmentGranularity) {
        return this.property("segmentGranularity", segmentGranularity);
    }

    public TableBuilder clusterColumns(ClusterKeySpec ... clusterKeys) {
        return this.property("clusterKeys", Arrays.asList(clusterKeys));
    }

    public TableBuilder hiddenColumns(List<String> hiddenColumns) {
        return this.property("hiddenColumns", hiddenColumns);
    }

    public TableBuilder sealed(boolean sealed) {
        return this.property("sealed", sealed);
    }

    public TableBuilder hiddenColumns(String ... hiddenColumns) {
        return this.hiddenColumns(Arrays.asList(hiddenColumns));
    }

    public TableBuilder inputSource(Map<String, Object> inputSource) {
        return this.property("source", inputSource);
    }

    public TableBuilder inputFormat(Map<String, Object> format) {
        return this.property("format", format);
    }

    public TableBuilder columns(List<ColumnSpec> columns) {
        this.columns = columns;
        return this;
    }

    public List<ColumnSpec> columns() {
        return this.columns;
    }

    public TableBuilder column(ColumnSpec column) {
        if (Strings.isNullOrEmpty((String)column.name())) {
            throw new IAE("Column name is required", new Object[0]);
        }
        this.columns.add(column);
        return this;
    }

    public TableBuilder timeColumn() {
        return this.column("__time", "TIMESTAMP");
    }

    public TableBuilder column(String name, String sqlType) {
        return this.column(name, sqlType, null);
    }

    public TableBuilder column(String name, String sqlType, Map<String, Object> properties) {
        Preconditions.checkNotNull((Object)this.tableType);
        return this.column(new ColumnSpec(name, sqlType, properties));
    }

    public TableSpec buildSpec() {
        return new TableSpec(this.tableType, this.properties, this.columns);
    }

    public TableMetadata build() {
        return TableMetadata.newTable(this.id, this.buildSpec());
    }

    public ResolvedTable buildResolved(ObjectMapper mapper) {
        Preconditions.checkNotNull((Object)this.defn);
        return new ResolvedTable(this.defn, this.buildSpec(), mapper);
    }
}

