/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorReport;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.LagStats;
import org.apache.druid.server.security.ResourceAction;

public class NoopSupervisorSpec
implements SupervisorSpec {
    @Nullable
    @JsonProperty(value="dataSources")
    private List<String> datasources;
    @Nullable
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="suspended")
    private boolean suspended;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="source")
    private String source;

    @VisibleForTesting
    public NoopSupervisorSpec(String id, List<String> datasources) {
        this(id, datasources, null, null, null);
    }

    @JsonCreator
    public NoopSupervisorSpec(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="dataSources") @Nullable List<String> datasources, @JsonProperty(value="suspended") @Nullable Boolean suspended, @JsonProperty(value="type") @Nullable String type, @JsonProperty(value="source") @Nullable String source) {
        this.id = id;
        this.datasources = datasources == null ? new ArrayList() : datasources;
        this.suspended = false;
        this.type = "noop";
        this.source = "noop";
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    @JsonProperty(value="dataSources")
    public List<String> getDataSources() {
        return this.datasources;
    }

    @Override
    @JsonProperty(value="suspended")
    public boolean isSuspended() {
        return this.suspended;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @Override
    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return ImmutableSet.of();
    }

    @Override
    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @Override
    public Supervisor createSupervisor() {
        return new Supervisor(){

            @Override
            public void start() {
            }

            @Override
            public void stop(boolean stopGracefully) {
            }

            @Override
            public SupervisorReport getStatus() {
                return null;
            }

            @Override
            public SupervisorStateManager.State getState() {
                return SupervisorStateManager.BasicState.RUNNING;
            }

            @Override
            public void reset(DataSourceMetadata dataSourceMetadata) {
            }

            @Override
            public void checkpoint(int taskGroupId, DataSourceMetadata checkpointMetadata) {
            }

            @Override
            public LagStats computeLagStats() {
                return new LagStats(0L, 0L, 0L);
            }

            @Override
            public int getActiveTaskGroupsCount() {
                return -1;
            }
        };
    }

    @Override
    public SupervisorSpec createRunningSpec() {
        return new NoopSupervisorSpec(this.id, this.datasources);
    }

    @Override
    public SupervisorSpec createSuspendedSpec() {
        return new NoopSupervisorSpec(this.id, this.datasources);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoopSupervisorSpec spec = (NoopSupervisorSpec)o;
        return Objects.equals(this.datasources, spec.datasources) && Objects.equals(this.getId(), spec.getId());
    }

    public int hashCode() {
        return Objects.hash(this.datasources, this.getId());
    }
}

