/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.audit;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.HumanReadableBytesRange;

public class SQLAuditManagerConfig {
    @JsonProperty
    private long auditHistoryMillis = 604800000L;
    @JsonProperty
    private boolean includePayloadAsDimensionInMetric = false;
    @JsonProperty
    @HumanReadableBytesRange(min=-1L, message="maxPayloadSizeBytes must either be -1 (for disabling the check) or a non negative number")
    private HumanReadableBytes maxPayloadSizeBytes = HumanReadableBytes.valueOf((int)-1);
    @JsonProperty
    private boolean skipNullField = false;

    public long getAuditHistoryMillis() {
        return this.auditHistoryMillis;
    }

    public boolean getIncludePayloadAsDimensionInMetric() {
        return this.includePayloadAsDimensionInMetric;
    }

    public long getMaxPayloadSizeBytes() {
        return this.maxPayloadSizeBytes.getBytes();
    }

    public boolean isSkipNullField() {
        return this.skipNullField;
    }
}

