/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import java.util.Properties;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.RemoteChatHandler;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.segment.realtime.firehose.ChatHandlerResource;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.TLSServerConfig;
import org.apache.druid.server.initialization.jetty.JettyBindings;
import org.apache.druid.server.initialization.jetty.JettyServerModule;
import org.apache.druid.server.initialization.jetty.ServletFilterHolder;
import org.apache.druid.server.initialization.jetty.TaskIdResponseHeaderFilterHolder;
import org.apache.druid.server.metrics.DataSourceTaskIdHolder;
import org.apache.druid.server.security.TLSCertificateChecker;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class CliIndexerServerModule
implements Module {
    private static final String SERVER_HTTP_NUM_THREADS_PROPERTY = "druid.server.http.numThreads";
    private final Properties properties;

    public CliIndexerServerModule(Properties properties) {
        this.properties = properties;
    }

    public void configure(Binder binder) {
        Jerseys.addResource((Binder)binder, ChatHandlerResource.class);
        LifecycleModule.register((Binder)binder, ChatHandlerResource.class);
        int serverHttpNumThreads = this.properties.getProperty(SERVER_HTTP_NUM_THREADS_PROPERTY) == null ? ServerConfig.getDefaultNumThreads() : Integer.parseInt(this.properties.getProperty(SERVER_HTTP_NUM_THREADS_PROPERTY));
        JettyBindings.addQosFilter(binder, "/druid/worker/v1/chat/*", serverHttpNumThreads);
        String[] notChatPaths = new String[]{"/druid/v2/*", "/status/*", "/druid-internal/*", "/druid/worker/v1/enable", "/druid/worker/v1/disable", "/druid/worker/v1/enabled", "/druid/worker/v1/tasks", "/druid/worker/v1/task/*", "/druid/v1/lookups/*", "/druid-ext/*"};
        JettyBindings.addQosFilter(binder, notChatPaths, serverHttpNumThreads);
        Multibinder.newSetBinder((Binder)binder, ServletFilterHolder.class).addBinding().to(TaskIdResponseHeaderFilterHolder.class);
        binder.bind(DruidNode.class).annotatedWith(RemoteChatHandler.class).to(Key.get(DruidNode.class, Self.class));
        binder.bind(ServerConfig.class).annotatedWith(RemoteChatHandler.class).to(Key.get(ServerConfig.class));
        binder.bind(TLSServerConfig.class).annotatedWith(RemoteChatHandler.class).to(Key.get(TLSServerConfig.class));
    }

    @Provides
    @LazySingleton
    public TaskIdResponseHeaderFilterHolder taskIdResponseHeaderFilterHolderBuilder(DataSourceTaskIdHolder taskIdHolder) {
        return new TaskIdResponseHeaderFilterHolder("/druid/worker/v1/chat/*", taskIdHolder.getTaskId());
    }

    @Provides
    @LazySingleton
    @RemoteChatHandler
    public Server getServer(Injector injector, Lifecycle lifecycle, @RemoteChatHandler DruidNode node, @RemoteChatHandler ServerConfig config, @RemoteChatHandler TLSServerConfig TLSServerConfig2) {
        return JettyServerModule.makeAndInitializeServer(injector, lifecycle, node, this.makeAdjustedServerConfig(config), TLSServerConfig2, (Binding<SslContextFactory.Server>)injector.getExistingBinding(Key.get(SslContextFactory.Server.class)), (TLSCertificateChecker)injector.getInstance(TLSCertificateChecker.class));
    }

    public ServerConfig makeAdjustedServerConfig(ServerConfig oldConfig) {
        return new ServerConfig(oldConfig.getNumThreads() * 2 + 2, oldConfig.getQueueSize(), oldConfig.isEnableRequestLimit(), oldConfig.getMaxIdleTime(), oldConfig.getDefaultQueryTimeout(), oldConfig.getMaxScatterGatherBytes(), oldConfig.getMaxSubqueryRows(), oldConfig.getMaxQueryTimeout(), oldConfig.getMaxRequestHeaderSize(), oldConfig.getGracefulShutdownTimeout(), oldConfig.getUnannouncePropagationDelay(), oldConfig.getInflateBufferSize(), oldConfig.getCompressionLevel(), oldConfig.isEnableForwardedRequestCustomizer(), oldConfig.getAllowedHttpMethods(), oldConfig.isShowDetailedJettyErrors(), oldConfig.getErrorResponseTransformStrategy(), oldConfig.getContentSecurityPolicy(), oldConfig.isEnableHSTS());
    }
}

