/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class Columns {
    public static final String TIME_COLUMN = "__time";
    public static final String VARCHAR = "VARCHAR";
    public static final String BIGINT = "BIGINT";
    public static final String FLOAT = "FLOAT";
    public static final String DOUBLE = "DOUBLE";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final Set<String> NUMERIC_TYPES = ImmutableSet.of((Object)"BIGINT", (Object)"FLOAT", (Object)"DOUBLE");
    public static final Set<String> SCALAR_TYPES = ImmutableSet.of((Object)"TIMESTAMP", (Object)"VARCHAR", (Object)"BIGINT", (Object)"FLOAT", (Object)"DOUBLE");
    public static final Map<String, ColumnType> SQL_TO_DRUID_TYPES = new ImmutableMap.Builder().put((Object)"TIMESTAMP", (Object)ColumnType.LONG).put((Object)"BIGINT", (Object)ColumnType.LONG).put((Object)"FLOAT", (Object)ColumnType.FLOAT).put((Object)"DOUBLE", (Object)ColumnType.DOUBLE).put((Object)"VARCHAR", (Object)ColumnType.STRING).build();
    public static final Map<ColumnType, String> DRUID_TO_SQL_TYPES = new ImmutableMap.Builder().put((Object)ColumnType.LONG, (Object)"BIGINT").put((Object)ColumnType.FLOAT, (Object)"FLOAT").put((Object)ColumnType.DOUBLE, (Object)"DOUBLE").put((Object)ColumnType.STRING, (Object)"VARCHAR").build();

    private Columns() {
    }

    public static boolean isTimestamp(String type) {
        return TIMESTAMP.equalsIgnoreCase(type.trim());
    }

    public static boolean isScalar(String type) {
        return SCALAR_TYPES.contains(StringUtils.toUpperCase((String)type.trim()));
    }

    public static ColumnType druidType(String sqlType) {
        if (sqlType == null) {
            return null;
        }
        ColumnType druidType = SQL_TO_DRUID_TYPES.get(StringUtils.toUpperCase((String)sqlType));
        if (druidType != null) {
            return druidType;
        }
        return ColumnType.fromString((String)sqlType);
    }

    public static void validateScalarColumn(String name, String type) {
        if (type == null) {
            return;
        }
        if (!Columns.isScalar(type)) {
            throw new IAE("Not a supported SQL type: " + type, new Object[0]);
        }
    }

    public static boolean isTimeColumn(String name) {
        return TIME_COLUMN.equals(name);
    }

    public static RowSignature convertSignature(List<ColumnSpec> columns) {
        RowSignature.Builder builder = RowSignature.builder();
        for (ColumnSpec col : columns) {
            ColumnType druidType = null;
            if (col.sqlType() != null) {
                druidType = Columns.druidType(col.sqlType());
            }
            if (druidType == null) {
                druidType = ColumnType.STRING;
            }
            builder.add(col.name(), druidType);
        }
        return builder.build();
    }

    public static String sqlType(ColumnType druidType) {
        return DRUID_TO_SQL_TYPES.get(druidType);
    }
}

