/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.facade;

import java.util.Collections;
import java.util.List;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.facade.TableFacade;
import org.apache.druid.catalog.model.table.ClusterKeySpec;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;

public class DatasourceFacade
extends TableFacade {
    private static final Logger LOG = new Logger(DatasourceFacade.class);

    public DatasourceFacade(ResolvedTable resolved) {
        super(resolved);
    }

    public String segmentGranularityString() {
        return this.stringProperty("segmentGranularity");
    }

    public Granularity segmentGranularity() {
        String definedGranularity = this.segmentGranularityString();
        return definedGranularity == null ? null : CatalogUtils.asDruidGranularity(definedGranularity);
    }

    public Integer targetSegmentRows() {
        return this.intProperty("targetSegmentRows");
    }

    public List<ClusterKeySpec> clusterKeys() {
        Object value = this.property("clusterKeys");
        if (value == null) {
            return Collections.emptyList();
        }
        try {
            return (List)this.jsonMapper().convertValue(value, ClusterKeySpec.CLUSTER_KEY_LIST_TYPE_REF);
        }
        catch (Exception e) {
            LOG.error("Failed to convert a catalog %s property of value [%s]", new Object[]{"clusterKeys", value});
            return Collections.emptyList();
        }
    }

    public List<String> hiddenColumns() {
        Object value = this.property("hiddenColumns");
        return value == null ? Collections.emptyList() : (List)value;
    }

    public boolean isSealed() {
        return this.booleanProperty("sealed");
    }
}

