/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.name.Named;
import com.google.inject.util.Providers;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.client.DruidServerConfig;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.ServerTypeConfig;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.StorageLocation;
import org.apache.druid.segment.loading.StorageLocationSelectorStrategy;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;

public class StorageNodeModule
implements Module {
    private static final EmittingLogger log = new EmittingLogger(StorageNodeModule.class);
    @VisibleForTesting
    static final String IS_SEGMENT_CACHE_CONFIGURED = "IS_SEGMENT_CACHE_CONFIGURED";

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.server", DruidServerConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.segmentCache", SegmentLoaderConfig.class);
        StorageNodeModule.bindLocationSelectorStrategy(binder);
        binder.bind(ServerTypeConfig.class).toProvider(Providers.of(null));
        binder.bind(ColumnConfig.class).to(DruidProcessingConfig.class);
    }

    @Provides
    @LazySingleton
    public DruidServerMetadata getMetadata(@Self DruidNode node, @Nullable ServerTypeConfig serverTypeConfig, DruidServerConfig config) {
        if (serverTypeConfig == null) {
            throw new ProvisionException("Must override the binding for ServerTypeConfig if you want a DruidServerMetadata.");
        }
        return new DruidServerMetadata(node.getHostAndPortToUse(), node.getHostAndPort(), node.getHostAndTlsPort(), config.getMaxSize(), serverTypeConfig.getServerType(), config.getTier(), config.getPriority());
    }

    @Provides
    @LazySingleton
    public DataNodeService getDataNodeService(@Nullable ServerTypeConfig serverTypeConfig, DruidServerConfig config, @Named(value="IS_SEGMENT_CACHE_CONFIGURED") Boolean isSegmentCacheConfigured) {
        if (serverTypeConfig == null) {
            throw new ProvisionException("Must override the binding for ServerTypeConfig if you want a DataNodeService.");
        }
        if (!isSegmentCacheConfigured.booleanValue()) {
            log.info("Segment cache not configured on ServerType [%s]. It will not be assignable for segment placement", new Object[]{serverTypeConfig.getServerType()});
            if (ServerType.HISTORICAL.equals((Object)serverTypeConfig.getServerType())) {
                throw new ProvisionException("druid.segmentCache.locations must be set on historicals.");
            }
        }
        return new DataNodeService(config.getTier(), config.getMaxSize(), serverTypeConfig.getServerType(), config.getPriority(), isSegmentCacheConfigured);
    }

    @Provides
    @LazySingleton
    @Named(value="IS_SEGMENT_CACHE_CONFIGURED")
    public Boolean isSegmentCacheConfigured(SegmentLoaderConfig segmentLoaderConfig) {
        return !segmentLoaderConfig.getLocations().isEmpty();
    }

    @Provides
    @LazySingleton
    public List<StorageLocation> provideStorageLocation(SegmentLoaderConfig config) {
        return config.toStorageLocations();
    }

    public static void bindLocationSelectorStrategy(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.segmentCache.locationSelector", StorageLocationSelectorStrategy.class);
    }
}

