/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.druid.segment.loading.LoadSpec;
import org.apache.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.druid.segment.loading.SegmentLoadingException;

@JsonTypeName(value="local")
public class LocalLoadSpec
implements LoadSpec {
    private final Path path;
    private final LocalDataSegmentPuller puller;

    @JsonCreator
    public LocalLoadSpec(@JacksonInject LocalDataSegmentPuller puller, @JsonProperty(value="path", required=true) String path) {
        Preconditions.checkNotNull((Object)path);
        this.path = Paths.get(path, new String[0]);
        this.puller = puller;
    }

    @JsonProperty
    public String getPath() {
        return this.path.toString();
    }

    public LoadSpec.LoadSpecResult loadSegment(File outDir) throws SegmentLoadingException {
        Preconditions.checkArgument((boolean)Files.exists(this.path, new LinkOption[0]), (String)"[%s] does not exist", (Object[])new Object[]{this.path});
        return new LoadSpec.LoadSpecResult(this.puller.getSegmentFiles(this.path.toFile(), outDir).size());
    }
}

