/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.plumber;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexAddResult;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.realtime.FireHydrant;
import org.apache.druid.segment.realtime.plumber.Plumber;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;

public class Sink
implements Iterable<FireHydrant>,
Overshadowable<Sink> {
    private static final IncrementalIndexAddResult ALREADY_SWAPPED = new IncrementalIndexAddResult(-1, -1L, "write after index swapped");
    private final Object hydrantLock = new Object();
    private final Interval interval;
    private final DataSchema schema;
    private final ShardSpec shardSpec;
    private final String version;
    private final AppendableIndexSpec appendableIndexSpec;
    private final int maxRowsInMemory;
    private final long maxBytesInMemory;
    private final boolean useMaxMemoryEstimates;
    private final CopyOnWriteArrayList<FireHydrant> hydrants = new CopyOnWriteArrayList();
    private final LinkedHashSet<String> dimOrder = new LinkedHashSet();
    private final AtomicInteger numRowsExcludingCurrIndex = new AtomicInteger();
    private final String dedupColumn;
    private final Set<Long> dedupSet = new HashSet<Long>();
    private volatile FireHydrant currHydrant;
    private volatile boolean writable = true;

    public Sink(Interval interval, DataSchema schema, ShardSpec shardSpec, String version, AppendableIndexSpec appendableIndexSpec, int maxRowsInMemory, long maxBytesInMemory, boolean useMaxMemoryEstimates, String dedupColumn) {
        this(interval, schema, shardSpec, version, appendableIndexSpec, maxRowsInMemory, maxBytesInMemory, useMaxMemoryEstimates, dedupColumn, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink(Interval interval, DataSchema schema, ShardSpec shardSpec, String version, AppendableIndexSpec appendableIndexSpec, int maxRowsInMemory, long maxBytesInMemory, boolean useMaxMemoryEstimates, String dedupColumn, List<FireHydrant> hydrants) {
        this.schema = schema;
        this.shardSpec = shardSpec;
        this.interval = interval;
        this.version = version;
        this.appendableIndexSpec = appendableIndexSpec;
        this.maxRowsInMemory = maxRowsInMemory;
        this.maxBytesInMemory = maxBytesInMemory;
        this.useMaxMemoryEstimates = useMaxMemoryEstimates;
        this.dedupColumn = dedupColumn;
        int maxCount = -1;
        for (int i = 0; i < hydrants.size(); ++i) {
            FireHydrant hydrant = hydrants.get(i);
            if (hydrant.getCount() <= maxCount) {
                throw new ISE("hydrant[%s] not the right count[%s]", new Object[]{hydrant, i});
            }
            maxCount = hydrant.getCount();
            ReferenceCountingSegment segment = hydrant.getIncrementedSegment();
            try {
                this.numRowsExcludingCurrIndex.addAndGet(segment.asQueryableIndex().getNumRows());
                continue;
            }
            finally {
                segment.decrement();
            }
        }
        this.hydrants.addAll(hydrants);
        this.makeNewCurrIndex(interval.getStartMillis(), schema);
    }

    public void clearDedupCache() {
        this.dedupSet.clear();
    }

    public Interval getInterval() {
        return this.interval;
    }

    public FireHydrant getCurrHydrant() {
        return this.currHydrant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalIndexAddResult add(InputRow row, boolean skipMaxRowsInMemoryCheck) throws IndexSizeExceededException {
        if (this.currHydrant == null) {
            throw new IAE("No currHydrant but given row[%s]", new Object[]{row});
        }
        Object object = this.hydrantLock;
        synchronized (object) {
            if (!this.writable) {
                return Plumber.NOT_WRITABLE;
            }
            IncrementalIndex index = this.currHydrant.getIndex();
            if (index == null) {
                return ALREADY_SWAPPED;
            }
            if (this.checkInDedupSet(row)) {
                return Plumber.DUPLICATE;
            }
            return index.add(row, skipMaxRowsInMemoryCheck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAppendRow() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.writable && this.currHydrant != null && this.currHydrant.getIndex().canAppendRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.hydrants.size() == 1 && this.currHydrant.getIndex().isEmpty();
        }
    }

    public boolean isWritable() {
        return this.writable;
    }

    public FireHydrant swap() {
        return this.makeNewCurrIndex(this.interval.getStartMillis(), this.schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swappable() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.writable && this.currHydrant.getIndex() != null && this.currHydrant.getIndex().size() != 0;
        }
    }

    public boolean finished() {
        return !this.writable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishWriting() {
        Object object = this.hydrantLock;
        synchronized (object) {
            if (!this.writable) {
                return false;
            }
            this.writable = false;
            this.clearDedupCache();
        }
        return true;
    }

    public DataSegment getSegment() {
        return new DataSegment(this.schema.getDataSource(), this.interval, this.version, (Map)ImmutableMap.of(), Collections.emptyList(), Lists.transform(Arrays.asList(this.schema.getAggregators()), AggregatorFactory::getName), this.shardSpec, null, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRows() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.numRowsExcludingCurrIndex.get() + this.getNumRowsInMemory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRowsInMemory() {
        Object object = this.hydrantLock;
        synchronized (object) {
            IncrementalIndex index = this.currHydrant.getIndex();
            if (index == null) {
                return 0;
            }
            return this.currHydrant.getIndex().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesInMemory() {
        Object object = this.hydrantLock;
        synchronized (object) {
            IncrementalIndex index = this.currHydrant.getIndex();
            if (index == null) {
                return 0L;
            }
            return this.currHydrant.getIndex().getBytesInMemory().get();
        }
    }

    private boolean checkInDedupSet(InputRow row) {
        Object value;
        if (this.dedupColumn != null && (value = row.getRaw(this.dedupColumn)) != null) {
            if (value instanceof List) {
                throw new IAE("Dedup on multi-value field not support", new Object[0]);
            }
            Long pk = value instanceof Long || value instanceof Integer ? Long.valueOf(((Number)value).longValue()) : Long.valueOf(this.pkHash(String.valueOf(value)));
            if (this.dedupSet.contains(pk)) {
                return true;
            }
            this.dedupSet.add(pk);
        }
        return false;
    }

    private long pkHash(String s) {
        long seed = 131L;
        long hash = 0L;
        for (int i = 0; i < s.length(); ++i) {
            hash = hash * seed + (long)s.charAt(i);
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FireHydrant makeNewCurrIndex(long minTimestamp, DataSchema schema) {
        FireHydrant old;
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withTimestampSpec(schema.getTimestampSpec()).withQueryGranularity(schema.getGranularitySpec().getQueryGranularity()).withDimensionsSpec(schema.getDimensionsSpec()).withMetrics(schema.getAggregators()).withRollup(schema.getGranularitySpec().isRollup()).build();
        IncrementalIndex newIndex = this.appendableIndexSpec.builder().setIndexSchema(indexSchema).setMaxRowCount(this.maxRowsInMemory).setMaxBytesInMemory(this.maxBytesInMemory).setUseMaxMemoryEstimates(this.useMaxMemoryEstimates).build();
        Object object = this.hydrantLock;
        synchronized (object) {
            if (this.writable) {
                old = this.currHydrant;
                int newCount = 0;
                int numHydrants = this.hydrants.size();
                if (numHydrants > 0) {
                    FireHydrant lastHydrant = this.hydrants.get(numHydrants - 1);
                    newCount = lastHydrant.getCount() + 1;
                    if (!indexSchema.getDimensionsSpec().hasCustomDimensions()) {
                        Map<String, ColumnFormat> oldFormat;
                        if (lastHydrant.hasSwapped()) {
                            oldFormat = new HashMap();
                            ReferenceCountingSegment segment = lastHydrant.getIncrementedSegment();
                            try {
                                QueryableIndex oldIndex = segment.asQueryableIndex();
                                for (String dim : oldIndex.getAvailableDimensions()) {
                                    this.dimOrder.add(dim);
                                    oldFormat.put(dim, oldIndex.getColumnHolder(dim).getColumnFormat());
                                }
                            }
                            finally {
                                segment.decrement();
                            }
                        } else {
                            IncrementalIndex oldIndex = lastHydrant.getIndex();
                            this.dimOrder.addAll(oldIndex.getDimensionOrder());
                            oldFormat = oldIndex.getColumnFormats();
                        }
                        newIndex.loadDimensionIterable(this.dimOrder, oldFormat);
                    }
                }
                this.currHydrant = new FireHydrant(newIndex, newCount, this.getSegment().getId());
                if (old != null) {
                    this.numRowsExcludingCurrIndex.addAndGet(old.getIndex().size());
                }
            } else {
                newIndex.close();
                throw new ISE("finishWriting() called during swap", new Object[0]);
            }
            this.hydrants.add(this.currHydrant);
        }
        return old;
    }

    @Override
    public Iterator<FireHydrant> iterator() {
        return Iterators.filter(this.hydrants.iterator(), (Predicate)new Predicate<FireHydrant>(){

            public boolean apply(FireHydrant input) {
                IncrementalIndex index = input.getIndex();
                return index == null || index.size() != 0;
            }
        });
    }

    public String toString() {
        return "Sink{interval=" + this.interval + ", schema=" + this.schema + '}';
    }

    public boolean overshadows(Sink other) {
        return false;
    }

    public int getStartRootPartitionId() {
        return this.shardSpec.getStartRootPartitionId();
    }

    public int getEndRootPartitionId() {
        return this.shardSpec.getEndRootPartitionId();
    }

    public String getVersion() {
        return this.version;
    }

    public short getMinorVersion() {
        return this.shardSpec.getMinorVersion();
    }

    public short getAtomicUpdateGroupSize() {
        return this.shardSpec.getAtomicUpdateGroupSize();
    }
}

