/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DirectQueryProcessingPool;
import org.apache.druid.query.FluentQueryRunnerBuilder;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.QueryScheduler;
import org.joda.time.Interval;

public class LocalQuerySegmentWalker
implements QuerySegmentWalker {
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final SegmentWrangler segmentWrangler;
    private final JoinableFactoryWrapper joinableFactoryWrapper;
    private final QueryScheduler scheduler;
    private final ServiceEmitter emitter;

    @Inject
    public LocalQuerySegmentWalker(QueryRunnerFactoryConglomerate conglomerate, SegmentWrangler segmentWrangler, JoinableFactoryWrapper joinableFactoryWrapper, QueryScheduler scheduler, ServiceEmitter emitter) {
        this.conglomerate = conglomerate;
        this.segmentWrangler = segmentWrangler;
        this.joinableFactoryWrapper = joinableFactoryWrapper;
        this.scheduler = scheduler;
        this.emitter = emitter;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        DataSource dataSourceFromQuery = query.getDataSource();
        DataSourceAnalysis analysis = dataSourceFromQuery.getAnalysis();
        if (!analysis.isConcreteBased() || !dataSourceFromQuery.isGlobal()) {
            throw new IAE("Cannot query dataSource locally: %s", new Object[]{dataSourceFromQuery});
        }
        FunctionalIterable segments = FunctionalIterable.create((Iterable)this.segmentWrangler.getSegmentsForIntervals(analysis.getBaseDataSource(), intervals)).transform(ReferenceCountingSegment::wrapRootGenerationSegment);
        AtomicLong cpuAccumulator = new AtomicLong(0L);
        Function segmentMapFn = dataSourceFromQuery.createSegmentMapFunction(query, cpuAccumulator);
        QueryRunnerFactory queryRunnerFactory = this.conglomerate.findFactory(query);
        QueryRunner baseRunner = queryRunnerFactory.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, () -> LocalQuerySegmentWalker.lambda$getQueryRunnerForIntervals$0((Iterable)segments, segmentMapFn, queryRunnerFactory));
        return new FluentQueryRunnerBuilder(queryRunnerFactory.getToolchest()).create(this.scheduler.wrapQueryRunner(baseRunner)).applyPreMergeDecoration().mergeResults().applyPostMergeDecoration().emitCPUTimeMetric(this.emitter, cpuAccumulator);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        throw new ISE("Cannot run with specific segments", new Object[0]);
    }

    private static /* synthetic */ Iterator lambda$getQueryRunnerForIntervals$0(Iterable segments, Function segmentMapFn, QueryRunnerFactory queryRunnerFactory) {
        return StreamSupport.stream(segments.spliterator(), false).map(segmentMapFn).map(arg_0 -> ((QueryRunnerFactory)queryRunnerFactory).createRunner(arg_0)).iterator();
    }
}

