/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.BadJsonQueryException;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.QueryResultPusher;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.ResourceAction;
import org.joda.time.DateTime;

@LazySingleton
@Path(value="/druid/v2/")
public class QueryResource
implements QueryCountStatsProvider {
    protected static final EmittingLogger log = new EmittingLogger(QueryResource.class);
    public static final EmittingLogger NO_STACK_LOGGER = log.noStackTrace();
    @Deprecated
    protected static final String APPLICATION_SMILE = "application/smile";
    public static final String HEADER_RESPONSE_CONTEXT = "X-Druid-Response-Context";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String QUERY_ID_RESPONSE_HEADER = "X-Druid-Query-Id";
    public static final String HEADER_ETAG = "ETag";
    protected final QueryLifecycleFactory queryLifecycleFactory;
    protected final ObjectMapper jsonMapper;
    protected final ObjectMapper smileMapper;
    protected final ObjectMapper serializeDateTimeAsLongJsonMapper;
    protected final ObjectMapper serializeDateTimeAsLongSmileMapper;
    protected final QueryScheduler queryScheduler;
    protected final AuthorizerMapper authorizerMapper;
    private final ResponseContextConfig responseContextConfig;
    private final DruidNode selfNode;
    private final AtomicLong successfulQueryCount = new AtomicLong();
    private final AtomicLong failedQueryCount = new AtomicLong();
    private final AtomicLong interruptedQueryCount = new AtomicLong();
    private final AtomicLong timedOutQueryCount = new AtomicLong();
    private final QueryResourceQueryMetricCounter counter = new QueryResourceQueryMetricCounter();

    @Inject
    public QueryResource(QueryLifecycleFactory queryLifecycleFactory, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QueryScheduler queryScheduler, AuthConfig authConfig, AuthorizerMapper authorizerMapper, ResponseContextConfig responseContextConfig, @Self DruidNode selfNode) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.serializeDateTimeAsLongJsonMapper = this.serializeDataTimeAsLong(jsonMapper);
        this.serializeDateTimeAsLongSmileMapper = this.serializeDataTimeAsLong(smileMapper);
        this.queryScheduler = queryScheduler;
        this.authorizerMapper = authorizerMapper;
        this.responseContextConfig = responseContextConfig;
        this.selfNode = selfNode;
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="id") String queryId, @Context HttpServletRequest req) {
        Access authResult;
        Set<String> datasources;
        if (log.isDebugEnabled()) {
            log.debug("Received cancel request for query [%s]", new Object[]{queryId});
        }
        if ((datasources = this.queryScheduler.getQueryDatasources(queryId)) == null) {
            log.warn("QueryId [%s] not registered with QueryScheduler, cannot cancel", new Object[]{queryId});
            datasources = new TreeSet<String>();
        }
        if (!(authResult = AuthorizationUtils.authorizeAllResourceActions(req, (Iterable<ResourceAction>)Iterables.transform(datasources, AuthorizationUtils.DATASOURCE_WRITE_RA_GENERATOR), this.authorizerMapper)).isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        this.queryScheduler.cancelQuery(queryId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/smile"})
    @Nullable
    public Response doPost(InputStream in, @QueryParam(value="pretty") String pretty, @Context HttpServletRequest req) throws IOException {
        QueryLifecycle queryLifecycle = this.queryLifecycleFactory.factorize();
        ResourceIOReaderWriter io = this.createResourceIOReaderWriter(req, pretty != null);
        String currThreadName = Thread.currentThread().getName();
        try {
            Access authResult;
            Query<?> query;
            try {
                query = this.readQuery(req, in, io);
            }
            catch (QueryException e) {
                Response response = io.getResponseWriter().buildNonOkResponse(e.getFailType().getExpectedStatus(), (Exception)((Object)e));
                Thread.currentThread().setName(currThreadName);
                return response;
            }
            queryLifecycle.initialize(query);
            String queryThreadName = queryLifecycle.threadName(currThreadName);
            Thread.currentThread().setName(queryThreadName);
            if (log.isDebugEnabled()) {
                log.debug("Got query [%s]", new Object[]{queryLifecycle.getQuery()});
            }
            try {
                authResult = queryLifecycle.authorize(req);
            }
            catch (RuntimeException e) {
                QueryException qe = e instanceof QueryException ? (QueryException)((Object)e) : new QueryInterruptedException((Throwable)e);
                Response response = io.getResponseWriter().buildNonOkResponse(qe.getFailType().getExpectedStatus(), (Exception)((Object)qe));
                Thread.currentThread().setName(currThreadName);
                return response;
            }
            if (!authResult.isAllowed()) {
                throw new ForbiddenException(authResult.toString());
            }
            QueryResourceQueryResultPusher pusher = new QueryResourceQueryResultPusher(req, queryLifecycle, io);
            Response response = pusher.push();
            return response;
        }
        catch (Exception e) {
            if (e instanceof ForbiddenException && !req.isAsyncStarted()) {
                throw e;
            }
            log.warn((Throwable)e, "Uncaught exception from query processing.  This should be caught and handled directly.", new Object[0]);
            AsyncContext asyncContext = req.startAsync();
            try {
                HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                if (!response.isCommitted()) {
                    response.setStatus(500);
                    response.setContentType("application/json");
                    try (ServletOutputStream out = response.getOutputStream();){
                        QueryException responseException = new QueryException("Unknown exception", "Unhandled exception made it to the top", e.getClass().getName(), req.getRemoteHost());
                        out.write(this.jsonMapper.writeValueAsBytes((Object)responseException));
                    }
                }
                Response response2 = null;
                return response2;
            }
            finally {
                asyncContext.complete();
            }
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    private Query<?> readQuery(HttpServletRequest req, InputStream in, ResourceIOReaderWriter ioReaderWriter) throws IOException {
        Query baseQuery;
        try {
            baseQuery = (Query)ioReaderWriter.getRequestMapper().readValue(in, Query.class);
        }
        catch (JsonParseException e) {
            throw new BadJsonQueryException(e);
        }
        String prevEtag = QueryResource.getPreviousEtag(req);
        if (prevEtag == null) {
            return baseQuery;
        }
        return baseQuery.withOverriddenContext(QueryContexts.override((Map)baseQuery.getContext(), (String)HEADER_IF_NONE_MATCH, (Object)prevEtag));
    }

    private static String getPreviousEtag(HttpServletRequest req) {
        return req.getHeader(HEADER_IF_NONE_MATCH);
    }

    protected ObjectMapper serializeDataTimeAsLong(ObjectMapper mapper) {
        return mapper.copy().registerModule((Module)new SimpleModule().addSerializer(DateTime.class, (JsonSerializer)new DateTimeSerializer()));
    }

    protected ResourceIOReaderWriter createResourceIOReaderWriter(HttpServletRequest req, boolean pretty) {
        String requestType = req.getContentType();
        String acceptHeader = req.getHeader("Accept");
        String responseType = Strings.isNullOrEmpty((String)acceptHeader) ? requestType : acceptHeader;
        boolean isRequestSmile = "application/x-jackson-smile".equals(requestType) || APPLICATION_SMILE.equals(requestType);
        boolean isResponseSmile = "application/x-jackson-smile".equals(responseType) || APPLICATION_SMILE.equals(responseType);
        return new ResourceIOReaderWriter(isRequestSmile ? this.smileMapper : this.jsonMapper, new ResourceIOWriter(isResponseSmile ? "application/x-jackson-smile" : "application/json", isResponseSmile ? this.smileMapper : this.jsonMapper, isResponseSmile ? this.serializeDateTimeAsLongSmileMapper : this.serializeDateTimeAsLongJsonMapper, pretty));
    }

    @Override
    public long getSuccessfulQueryCount() {
        return this.successfulQueryCount.get();
    }

    @Override
    public long getFailedQueryCount() {
        return this.failedQueryCount.get();
    }

    @Override
    public long getInterruptedQueryCount() {
        return this.interruptedQueryCount.get();
    }

    @Override
    public long getTimedOutQueryCount() {
        return this.timedOutQueryCount.get();
    }

    @VisibleForTesting
    public static void transferEntityTag(ResponseContext context, Response.ResponseBuilder builder) {
        Object entityTag = context.remove(ResponseContext.Keys.ETAG);
        if (entityTag != null) {
            builder.header(HEADER_ETAG, entityTag);
        }
    }

    private class QueryResourceQueryResultPusher
    extends QueryResultPusher {
        private final HttpServletRequest req;
        private final QueryLifecycle queryLifecycle;
        private final ResourceIOReaderWriter io;

        public QueryResourceQueryResultPusher(HttpServletRequest req, QueryLifecycle queryLifecycle, ResourceIOReaderWriter io) {
            super(req, QueryResource.this.jsonMapper, QueryResource.this.responseContextConfig, QueryResource.this.selfNode, QueryResource.this.counter, queryLifecycle.getQueryId(), MediaType.valueOf((String)io.getResponseWriter().getResponseType()), (Map<String, String>)ImmutableMap.of());
            this.req = req;
            this.queryLifecycle = queryLifecycle;
            this.io = io;
        }

        @Override
        public QueryResultPusher.ResultsWriter start() {
            return new QueryResultPusher.ResultsWriter(){
                private QueryResponse<Object> queryResponse;

                @Override
                public Response.ResponseBuilder start() {
                    this.queryResponse = QueryResourceQueryResultPusher.this.queryLifecycle.execute();
                    ResponseContext responseContext = this.queryResponse.getResponseContext();
                    String prevEtag = QueryResource.getPreviousEtag(QueryResourceQueryResultPusher.this.req);
                    if (prevEtag != null && prevEtag.equals(responseContext.getEntityTag())) {
                        QueryResourceQueryResultPusher.this.queryLifecycle.emitLogsAndMetrics(null, QueryResourceQueryResultPusher.this.req.getRemoteAddr(), -1L);
                        QueryResource.this.counter.incrementSuccess();
                        return Response.status((Response.Status)Response.Status.NOT_MODIFIED);
                    }
                    return null;
                }

                @Override
                public QueryResponse<Object> getQueryResponse() {
                    return this.queryResponse;
                }

                @Override
                public QueryResultPusher.Writer makeWriter(OutputStream out) throws IOException {
                    ObjectWriter objectWriter = QueryResourceQueryResultPusher.this.queryLifecycle.newOutputWriter(QueryResourceQueryResultPusher.this.io);
                    final SequenceWriter sequenceWriter = objectWriter.writeValuesAsArray(out);
                    return new QueryResultPusher.Writer(){

                        @Override
                        public void writeResponseStart() {
                        }

                        @Override
                        public void writeRow(Object obj) throws IOException {
                            sequenceWriter.write(obj);
                        }

                        @Override
                        public void writeResponseEnd() {
                        }

                        @Override
                        public void close() throws IOException {
                            sequenceWriter.close();
                        }
                    };
                }

                @Override
                public void recordSuccess(long numBytes) {
                    QueryResourceQueryResultPusher.this.queryLifecycle.emitLogsAndMetrics(null, QueryResourceQueryResultPusher.this.req.getRemoteAddr(), numBytes);
                }

                @Override
                public void recordFailure(Exception e) {
                    QueryResourceQueryResultPusher.this.queryLifecycle.emitLogsAndMetrics(e, QueryResourceQueryResultPusher.this.req.getRemoteAddr(), -1L);
                }

                @Override
                public void close() {
                }
            };
        }

        @Override
        public void writeException(Exception e, OutputStream out) throws IOException {
            ObjectWriter objectWriter = this.queryLifecycle.newOutputWriter(this.io);
            out.write(objectWriter.writeValueAsBytes((Object)e));
        }
    }

    private class QueryResourceQueryMetricCounter
    implements QueryMetricCounter {
        private QueryResourceQueryMetricCounter() {
        }

        @Override
        public void incrementSuccess() {
            QueryResource.this.successfulQueryCount.incrementAndGet();
        }

        @Override
        public void incrementFailed() {
            QueryResource.this.failedQueryCount.incrementAndGet();
        }

        @Override
        public void incrementInterrupted() {
            QueryResource.this.interruptedQueryCount.incrementAndGet();
        }

        @Override
        public void incrementTimedOut() {
            QueryResource.this.timedOutQueryCount.incrementAndGet();
        }
    }

    protected static class ResourceIOWriter {
        private final String responseType;
        private final ObjectMapper inputMapper;
        private final ObjectMapper serializeDateTimeAsLongInputMapper;
        private final boolean isPretty;

        ResourceIOWriter(String responseType, ObjectMapper inputMapper, ObjectMapper serializeDateTimeAsLongInputMapper, boolean isPretty) {
            this.responseType = responseType;
            this.inputMapper = inputMapper;
            this.serializeDateTimeAsLongInputMapper = serializeDateTimeAsLongInputMapper;
            this.isPretty = isPretty;
        }

        String getResponseType() {
            return this.responseType;
        }

        ObjectWriter newOutputWriter(@Nullable QueryToolChest<?, Query<?>> toolChest, @Nullable Query<?> query, boolean serializeDateTimeAsLong) {
            ObjectMapper mapper = serializeDateTimeAsLong ? this.serializeDateTimeAsLongInputMapper : this.inputMapper;
            ObjectMapper decoratedMapper = toolChest != null ? toolChest.decorateObjectMapper(mapper, (Query)Preconditions.checkNotNull(query, (Object)"query")) : mapper;
            return this.isPretty ? decoratedMapper.writerWithDefaultPrettyPrinter() : decoratedMapper.writer();
        }

        Response ok(Object object) throws IOException {
            return Response.ok((Object)this.newOutputWriter(null, null, false).writeValueAsString(object), (String)this.responseType).build();
        }

        Response gotError(Exception e) throws IOException {
            return this.buildNonOkResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Exception)QueryInterruptedException.wrapIfNeeded((Throwable)e));
        }

        Response buildNonOkResponse(int status, Exception e) throws JsonProcessingException {
            return Response.status((int)status).type(this.responseType).entity((Object)this.newOutputWriter(null, null, false).writeValueAsBytes((Object)e)).build();
        }
    }

    protected static class ResourceIOReaderWriter {
        private final ObjectMapper requestMapper;
        private final ResourceIOWriter writer;

        public ResourceIOReaderWriter(ObjectMapper requestMapper, ResourceIOWriter writer) {
            this.requestMapper = requestMapper;
            this.writer = writer;
        }

        public ObjectMapper getRequestMapper() {
            return this.requestMapper;
        }

        public ResourceIOWriter getResponseWriter() {
            return this.writer;
        }
    }

    public static interface QueryMetricCounter {
        public void incrementSuccess();

        public void incrementFailed();

        public void incrementInterrupted();

        public void incrementTimedOut();
    }
}

