/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.stats.Dimension;

public class CoordinatorDynamicConfig {
    public static final String CONFIG_KEY = "coordinator.config";
    private final long markSegmentAsUnusedDelayMillis;
    private final long mergeBytesLimit;
    private final int mergeSegmentsLimit;
    private final int maxSegmentsToMove;
    private final int replicantLifetime;
    private final int replicationThrottleLimit;
    private final int balancerComputeThreads;
    private final boolean useRoundRobinSegmentAssignment;
    private final boolean smartSegmentLoading;
    private final Set<String> specificDataSourcesToKillUnusedSegmentsIn;
    private final Set<String> decommissioningNodes;
    private final Map<String, String> debugDimensions;
    private final Map<Dimension, String> validDebugDimensions;
    @Deprecated
    private final int decommissioningMaxPercentOfMaxSegmentsToMove;
    private final Set<String> dataSourcesToNotKillStalePendingSegmentsIn;
    private final int maxSegmentsInNodeLoadingQueue;
    private final boolean pauseCoordination;
    private final boolean replicateAfterLoadTimeout;
    @Deprecated
    private final int maxNonPrimaryReplicantsToLoad;
    private static final Logger log = new Logger(CoordinatorDynamicConfig.class);

    @JsonCreator
    public CoordinatorDynamicConfig(@JsonProperty(value="millisToWaitBeforeDeleting") long markSegmentAsUnusedDelayMillis, @JsonProperty(value="mergeBytesLimit") long mergeBytesLimit, @JsonProperty(value="mergeSegmentsLimit") int mergeSegmentsLimit, @JsonProperty(value="maxSegmentsToMove") int maxSegmentsToMove, @JsonProperty(value="replicantLifetime") int replicantLifetime, @JsonProperty(value="replicationThrottleLimit") int replicationThrottleLimit, @JsonProperty(value="balancerComputeThreads") int balancerComputeThreads, @JsonProperty(value="killDataSourceWhitelist") Object specificDataSourcesToKillUnusedSegmentsIn, @JsonProperty(value="killPendingSegmentsSkipList") Object dataSourcesToNotKillStalePendingSegmentsIn, @JsonProperty(value="maxSegmentsInNodeLoadingQueue") @Nullable Integer maxSegmentsInNodeLoadingQueue, @JsonProperty(value="decommissioningNodes") Object decommissioningNodes, @JsonProperty(value="decommissioningMaxPercentOfMaxSegmentsToMove") int decommissioningMaxPercentOfMaxSegmentsToMove, @JsonProperty(value="pauseCoordination") boolean pauseCoordination, @JsonProperty(value="replicateAfterLoadTimeout") boolean replicateAfterLoadTimeout, @JsonProperty(value="maxNonPrimaryReplicantsToLoad") @Nullable Integer maxNonPrimaryReplicantsToLoad, @JsonProperty(value="useRoundRobinSegmentAssignment") @Nullable Boolean useRoundRobinSegmentAssignment, @JsonProperty(value="smartSegmentLoading") @Nullable Boolean smartSegmentLoading, @JsonProperty(value="debugDimensions") @Nullable Map<String, String> debugDimensions) {
        this.markSegmentAsUnusedDelayMillis = markSegmentAsUnusedDelayMillis;
        this.mergeBytesLimit = mergeBytesLimit;
        this.mergeSegmentsLimit = mergeSegmentsLimit;
        this.maxSegmentsToMove = maxSegmentsToMove;
        this.smartSegmentLoading = (Boolean)Builder.valueOrDefault(smartSegmentLoading, true);
        this.replicantLifetime = replicantLifetime;
        this.replicationThrottleLimit = replicationThrottleLimit;
        this.balancerComputeThreads = Math.max(balancerComputeThreads, 1);
        this.specificDataSourcesToKillUnusedSegmentsIn = CoordinatorDynamicConfig.parseJsonStringOrArray(specificDataSourcesToKillUnusedSegmentsIn);
        this.dataSourcesToNotKillStalePendingSegmentsIn = CoordinatorDynamicConfig.parseJsonStringOrArray(dataSourcesToNotKillStalePendingSegmentsIn);
        this.maxSegmentsInNodeLoadingQueue = (Integer)Builder.valueOrDefault(maxSegmentsInNodeLoadingQueue, 500);
        this.decommissioningNodes = CoordinatorDynamicConfig.parseJsonStringOrArray(decommissioningNodes);
        Preconditions.checkArgument((decommissioningMaxPercentOfMaxSegmentsToMove >= 0 && decommissioningMaxPercentOfMaxSegmentsToMove <= 100 ? 1 : 0) != 0, (Object)"'decommissioningMaxPercentOfMaxSegmentsToMove' should be in range [0, 100]");
        this.decommissioningMaxPercentOfMaxSegmentsToMove = decommissioningMaxPercentOfMaxSegmentsToMove;
        this.pauseCoordination = pauseCoordination;
        this.replicateAfterLoadTimeout = replicateAfterLoadTimeout;
        if (maxNonPrimaryReplicantsToLoad == null) {
            log.debug("maxNonPrimaryReplicantsToLoad was null! This is likely because your metastore does not reflect this configuration being added to Druid in a recent release. Druid is defaulting the value to the Druid default of %d. It is recommended that you re-submit your dynamic config with your desired value for maxNonPrimaryReplicantsToLoad", new Object[]{Integer.MAX_VALUE});
            maxNonPrimaryReplicantsToLoad = Integer.MAX_VALUE;
        }
        Preconditions.checkArgument((maxNonPrimaryReplicantsToLoad >= 0 ? 1 : 0) != 0, (Object)"maxNonPrimaryReplicantsToLoad must be greater than or equal to 0.");
        this.maxNonPrimaryReplicantsToLoad = maxNonPrimaryReplicantsToLoad;
        this.useRoundRobinSegmentAssignment = (Boolean)Builder.valueOrDefault(useRoundRobinSegmentAssignment, true);
        this.debugDimensions = debugDimensions;
        this.validDebugDimensions = this.validateDebugDimensions(debugDimensions);
    }

    private Map<Dimension, String> validateDebugDimensions(Map<String, String> debugDimensions) {
        EnumMap<Dimension, String> validDebugDimensions = new EnumMap<Dimension, String>(Dimension.class);
        if (debugDimensions == null || debugDimensions.isEmpty()) {
            return validDebugDimensions;
        }
        for (Dimension dimension : Dimension.values()) {
            String dimensionValue = debugDimensions.get(dimension.reportedName());
            if (dimensionValue == null) continue;
            validDebugDimensions.put(dimension, dimensionValue);
        }
        return validDebugDimensions;
    }

    private static Set<String> parseJsonStringOrArray(Object jsonStringOrArray) {
        if (jsonStringOrArray instanceof String) {
            String[] list = ((String)jsonStringOrArray).split(",");
            HashSet<String> result = new HashSet<String>();
            for (String item : list) {
                String trimmed = item.trim();
                if (trimmed.isEmpty()) continue;
                result.add(trimmed);
            }
            return result;
        }
        if (jsonStringOrArray instanceof Collection) {
            return ImmutableSet.copyOf((Collection)((Collection)jsonStringOrArray));
        }
        return ImmutableSet.of();
    }

    public static AtomicReference<CoordinatorDynamicConfig> watch(JacksonConfigManager configManager) {
        return configManager.watch(CONFIG_KEY, CoordinatorDynamicConfig.class, (Object)CoordinatorDynamicConfig.builder().build());
    }

    @Nonnull
    public static CoordinatorDynamicConfig current(JacksonConfigManager configManager) {
        return (CoordinatorDynamicConfig)Preconditions.checkNotNull((Object)CoordinatorDynamicConfig.watch(configManager).get(), (Object)"Got null config from watcher?!");
    }

    @JsonProperty(value="millisToWaitBeforeDeleting")
    public long getMarkSegmentAsUnusedDelayMillis() {
        return this.markSegmentAsUnusedDelayMillis;
    }

    @JsonProperty
    public long getMergeBytesLimit() {
        return this.mergeBytesLimit;
    }

    @JsonProperty
    public int getMergeSegmentsLimit() {
        return this.mergeSegmentsLimit;
    }

    @JsonProperty
    public int getMaxSegmentsToMove() {
        return this.maxSegmentsToMove;
    }

    @JsonProperty
    public int getReplicantLifetime() {
        return this.replicantLifetime;
    }

    @JsonProperty
    public int getReplicationThrottleLimit() {
        return this.replicationThrottleLimit;
    }

    @JsonProperty
    public int getBalancerComputeThreads() {
        return this.balancerComputeThreads;
    }

    @JsonProperty(value="killDataSourceWhitelist")
    public Set<String> getSpecificDataSourcesToKillUnusedSegmentsIn() {
        return this.specificDataSourcesToKillUnusedSegmentsIn;
    }

    @JsonIgnore
    public boolean isKillUnusedSegmentsInAllDataSources() {
        return this.specificDataSourcesToKillUnusedSegmentsIn.isEmpty();
    }

    @JsonProperty(value="killPendingSegmentsSkipList")
    public Set<String> getDataSourcesToNotKillStalePendingSegmentsIn() {
        return this.dataSourcesToNotKillStalePendingSegmentsIn;
    }

    @JsonProperty
    public int getMaxSegmentsInNodeLoadingQueue() {
        return this.maxSegmentsInNodeLoadingQueue;
    }

    @JsonProperty
    public boolean isUseRoundRobinSegmentAssignment() {
        return this.useRoundRobinSegmentAssignment;
    }

    @JsonProperty
    public boolean isSmartSegmentLoading() {
        return this.smartSegmentLoading;
    }

    @JsonProperty
    public Set<String> getDecommissioningNodes() {
        return this.decommissioningNodes;
    }

    @JsonProperty
    public Map<String, String> getDebugDimensions() {
        return this.debugDimensions;
    }

    @JsonIgnore
    public Map<Dimension, String> getValidatedDebugDimensions() {
        return this.validDebugDimensions;
    }

    @Min(value=0L)
    @Max(value=100L)
    @Deprecated
    @JsonProperty
    public int getDecommissioningMaxPercentOfMaxSegmentsToMove() {
        return this.decommissioningMaxPercentOfMaxSegmentsToMove;
    }

    @JsonProperty
    public boolean getPauseCoordination() {
        return this.pauseCoordination;
    }

    @JsonProperty
    public boolean getReplicateAfterLoadTimeout() {
        return this.replicateAfterLoadTimeout;
    }

    @Min(value=0L)
    @Deprecated
    @JsonProperty
    public int getMaxNonPrimaryReplicantsToLoad() {
        return this.maxNonPrimaryReplicantsToLoad;
    }

    public String toString() {
        return "CoordinatorDynamicConfig{leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments=" + this.markSegmentAsUnusedDelayMillis + ", mergeBytesLimit=" + this.mergeBytesLimit + ", mergeSegmentsLimit=" + this.mergeSegmentsLimit + ", maxSegmentsToMove=" + this.maxSegmentsToMove + ", replicantLifetime=" + this.replicantLifetime + ", replicationThrottleLimit=" + this.replicationThrottleLimit + ", balancerComputeThreads=" + this.balancerComputeThreads + ", specificDataSourcesToKillUnusedSegmentsIn=" + this.specificDataSourcesToKillUnusedSegmentsIn + ", dataSourcesToNotKillStalePendingSegmentsIn=" + this.dataSourcesToNotKillStalePendingSegmentsIn + ", maxSegmentsInNodeLoadingQueue=" + this.maxSegmentsInNodeLoadingQueue + ", decommissioningNodes=" + this.decommissioningNodes + ", decommissioningMaxPercentOfMaxSegmentsToMove=" + this.decommissioningMaxPercentOfMaxSegmentsToMove + ", pauseCoordination=" + this.pauseCoordination + ", replicateAfterLoadTimeout=" + this.replicateAfterLoadTimeout + ", maxNonPrimaryReplicantsToLoad=" + this.maxNonPrimaryReplicantsToLoad + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinatorDynamicConfig that = (CoordinatorDynamicConfig)o;
        return this.markSegmentAsUnusedDelayMillis == that.markSegmentAsUnusedDelayMillis && this.mergeBytesLimit == that.mergeBytesLimit && this.mergeSegmentsLimit == that.mergeSegmentsLimit && this.maxSegmentsToMove == that.maxSegmentsToMove && this.decommissioningMaxPercentOfMaxSegmentsToMove == that.decommissioningMaxPercentOfMaxSegmentsToMove && this.balancerComputeThreads == that.balancerComputeThreads && this.replicantLifetime == that.replicantLifetime && this.replicationThrottleLimit == that.replicationThrottleLimit && this.replicateAfterLoadTimeout == that.replicateAfterLoadTimeout && this.maxSegmentsInNodeLoadingQueue == that.maxSegmentsInNodeLoadingQueue && this.maxNonPrimaryReplicantsToLoad == that.maxNonPrimaryReplicantsToLoad && this.useRoundRobinSegmentAssignment == that.useRoundRobinSegmentAssignment && this.pauseCoordination == that.pauseCoordination && Objects.equals(this.specificDataSourcesToKillUnusedSegmentsIn, that.specificDataSourcesToKillUnusedSegmentsIn) && Objects.equals(this.dataSourcesToNotKillStalePendingSegmentsIn, that.dataSourcesToNotKillStalePendingSegmentsIn) && Objects.equals(this.decommissioningNodes, that.decommissioningNodes) && Objects.equals(this.debugDimensions, that.debugDimensions);
    }

    public int hashCode() {
        return Objects.hash(this.markSegmentAsUnusedDelayMillis, this.mergeBytesLimit, this.mergeSegmentsLimit, this.maxSegmentsToMove, this.replicantLifetime, this.replicationThrottleLimit, this.balancerComputeThreads, this.maxSegmentsInNodeLoadingQueue, this.specificDataSourcesToKillUnusedSegmentsIn, this.dataSourcesToNotKillStalePendingSegmentsIn, this.decommissioningNodes, this.decommissioningMaxPercentOfMaxSegmentsToMove, this.pauseCoordination, this.maxNonPrimaryReplicantsToLoad, this.debugDimensions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long markSegmentAsUnusedDelayMillis;
        private Long mergeBytesLimit;
        private Integer mergeSegmentsLimit;
        private Integer maxSegmentsToMove;
        private Integer replicantLifetime;
        private Integer replicationThrottleLimit;
        private Integer balancerComputeThreads;
        private Object specificDataSourcesToKillUnusedSegmentsIn;
        private Object dataSourcesToNotKillStalePendingSegmentsIn;
        private Integer maxSegmentsInNodeLoadingQueue;
        private Object decommissioningNodes;
        private Map<String, String> debugDimensions;
        private Integer decommissioningMaxPercentOfMaxSegmentsToMove;
        private Boolean pauseCoordination;
        private Boolean replicateAfterLoadTimeout;
        private Integer maxNonPrimaryReplicantsToLoad;
        private Boolean useRoundRobinSegmentAssignment;
        private Boolean smartSegmentLoading;

        public Builder() {
        }

        @JsonCreator
        public Builder(@JsonProperty(value="millisToWaitBeforeDeleting") @Nullable Long markSegmentAsUnusedDelayMillis, @JsonProperty(value="mergeBytesLimit") @Nullable Long mergeBytesLimit, @JsonProperty(value="mergeSegmentsLimit") @Nullable Integer mergeSegmentsLimit, @JsonProperty(value="maxSegmentsToMove") @Nullable Integer maxSegmentsToMove, @JsonProperty(value="replicantLifetime") @Nullable Integer replicantLifetime, @JsonProperty(value="replicationThrottleLimit") @Nullable Integer replicationThrottleLimit, @JsonProperty(value="balancerComputeThreads") @Nullable Integer balancerComputeThreads, @JsonProperty(value="killDataSourceWhitelist") @Nullable Object specificDataSourcesToKillUnusedSegmentsIn, @JsonProperty(value="killPendingSegmentsSkipList") @Nullable Object dataSourcesToNotKillStalePendingSegmentsIn, @JsonProperty(value="maxSegmentsInNodeLoadingQueue") @Nullable Integer maxSegmentsInNodeLoadingQueue, @JsonProperty(value="decommissioningNodes") @Nullable Object decommissioningNodes, @JsonProperty(value="decommissioningMaxPercentOfMaxSegmentsToMove") @Nullable Integer decommissioningMaxPercentOfMaxSegmentsToMove, @JsonProperty(value="pauseCoordination") @Nullable Boolean pauseCoordination, @JsonProperty(value="replicateAfterLoadTimeout") @Nullable Boolean replicateAfterLoadTimeout, @JsonProperty(value="maxNonPrimaryReplicantsToLoad") @Nullable Integer maxNonPrimaryReplicantsToLoad, @JsonProperty(value="useRoundRobinSegmentAssignment") @Nullable Boolean useRoundRobinSegmentAssignment, @JsonProperty(value="smartSegmentLoading") @Nullable Boolean smartSegmentLoading, @JsonProperty(value="debugDimensions") @Nullable Map<String, String> debugDimensions) {
            this.markSegmentAsUnusedDelayMillis = markSegmentAsUnusedDelayMillis;
            this.mergeBytesLimit = mergeBytesLimit;
            this.mergeSegmentsLimit = mergeSegmentsLimit;
            this.maxSegmentsToMove = maxSegmentsToMove;
            this.replicantLifetime = replicantLifetime;
            this.replicationThrottleLimit = replicationThrottleLimit;
            this.balancerComputeThreads = balancerComputeThreads;
            this.specificDataSourcesToKillUnusedSegmentsIn = specificDataSourcesToKillUnusedSegmentsIn;
            this.dataSourcesToNotKillStalePendingSegmentsIn = dataSourcesToNotKillStalePendingSegmentsIn;
            this.maxSegmentsInNodeLoadingQueue = maxSegmentsInNodeLoadingQueue;
            this.decommissioningNodes = decommissioningNodes;
            this.decommissioningMaxPercentOfMaxSegmentsToMove = decommissioningMaxPercentOfMaxSegmentsToMove;
            this.pauseCoordination = pauseCoordination;
            this.replicateAfterLoadTimeout = replicateAfterLoadTimeout;
            this.maxNonPrimaryReplicantsToLoad = maxNonPrimaryReplicantsToLoad;
            this.useRoundRobinSegmentAssignment = useRoundRobinSegmentAssignment;
            this.smartSegmentLoading = smartSegmentLoading;
            this.debugDimensions = debugDimensions;
        }

        public Builder withMarkSegmentAsUnusedDelayMillis(long leadingTimeMillis) {
            this.markSegmentAsUnusedDelayMillis = leadingTimeMillis;
            return this;
        }

        public Builder withMergeBytesLimit(long mergeBytesLimit) {
            this.mergeBytesLimit = mergeBytesLimit;
            return this;
        }

        public Builder withMergeSegmentsLimit(int mergeSegmentsLimit) {
            this.mergeSegmentsLimit = mergeSegmentsLimit;
            return this;
        }

        public Builder withMaxSegmentsToMove(int maxSegmentsToMove) {
            this.maxSegmentsToMove = maxSegmentsToMove;
            return this;
        }

        public Builder withSmartSegmentLoading(boolean smartSegmentLoading) {
            this.smartSegmentLoading = smartSegmentLoading;
            return this;
        }

        public Builder withReplicantLifetime(int replicantLifetime) {
            this.replicantLifetime = replicantLifetime;
            return this;
        }

        public Builder withReplicationThrottleLimit(int replicationThrottleLimit) {
            this.replicationThrottleLimit = replicationThrottleLimit;
            return this;
        }

        public Builder withDebugDimensions(Map<String, String> debugDimensions) {
            this.debugDimensions = debugDimensions;
            return this;
        }

        public Builder withBalancerComputeThreads(int balancerComputeThreads) {
            this.balancerComputeThreads = balancerComputeThreads;
            return this;
        }

        public Builder withSpecificDataSourcesToKillUnusedSegmentsIn(Set<String> dataSources) {
            this.specificDataSourcesToKillUnusedSegmentsIn = dataSources;
            return this;
        }

        public Builder withMaxSegmentsInNodeLoadingQueue(int maxSegmentsInNodeLoadingQueue) {
            this.maxSegmentsInNodeLoadingQueue = maxSegmentsInNodeLoadingQueue;
            return this;
        }

        public Builder withDecommissioningNodes(Set<String> decommissioning) {
            this.decommissioningNodes = decommissioning;
            return this;
        }

        public Builder withDecommissioningMaxPercentOfMaxSegmentsToMove(Integer percent) {
            this.decommissioningMaxPercentOfMaxSegmentsToMove = percent;
            return this;
        }

        public Builder withPauseCoordination(boolean pauseCoordination) {
            this.pauseCoordination = pauseCoordination;
            return this;
        }

        public Builder withReplicateAfterLoadTimeout(boolean replicateAfterLoadTimeout) {
            this.replicateAfterLoadTimeout = replicateAfterLoadTimeout;
            return this;
        }

        public Builder withMaxNonPrimaryReplicantsToLoad(int maxNonPrimaryReplicantsToLoad) {
            this.maxNonPrimaryReplicantsToLoad = maxNonPrimaryReplicantsToLoad;
            return this;
        }

        public Builder withUseRoundRobinSegmentAssignment(boolean useRoundRobinSegmentAssignment) {
            this.useRoundRobinSegmentAssignment = useRoundRobinSegmentAssignment;
            return this;
        }

        public CoordinatorDynamicConfig build() {
            return new CoordinatorDynamicConfig(Builder.valueOrDefault(this.markSegmentAsUnusedDelayMillis, Defaults.LEADING_MILLIS_BEFORE_MARK_UNUSED), Builder.valueOrDefault(this.mergeBytesLimit, 524288000L), Builder.valueOrDefault(this.mergeSegmentsLimit, 100), Builder.valueOrDefault(this.maxSegmentsToMove, 100), Builder.valueOrDefault(this.replicantLifetime, 15), Builder.valueOrDefault(this.replicationThrottleLimit, 500), Builder.valueOrDefault(this.balancerComputeThreads, 1), this.specificDataSourcesToKillUnusedSegmentsIn, this.dataSourcesToNotKillStalePendingSegmentsIn, Builder.valueOrDefault(this.maxSegmentsInNodeLoadingQueue, 500), this.decommissioningNodes, Builder.valueOrDefault(this.decommissioningMaxPercentOfMaxSegmentsToMove, 70), Builder.valueOrDefault(this.pauseCoordination, false), Builder.valueOrDefault(this.replicateAfterLoadTimeout, false), Builder.valueOrDefault(this.maxNonPrimaryReplicantsToLoad, Integer.MAX_VALUE), Builder.valueOrDefault(this.useRoundRobinSegmentAssignment, true), Builder.valueOrDefault(this.smartSegmentLoading, true), this.debugDimensions);
        }

        private static <T> T valueOrDefault(@Nullable T value, @NotNull T defaultValue) {
            return value == null ? defaultValue : value;
        }

        public CoordinatorDynamicConfig build(CoordinatorDynamicConfig defaults) {
            return new CoordinatorDynamicConfig(Builder.valueOrDefault(this.markSegmentAsUnusedDelayMillis, defaults.getMarkSegmentAsUnusedDelayMillis()), Builder.valueOrDefault(this.mergeBytesLimit, defaults.getMergeBytesLimit()), Builder.valueOrDefault(this.mergeSegmentsLimit, defaults.getMergeSegmentsLimit()), Builder.valueOrDefault(this.maxSegmentsToMove, defaults.getMaxSegmentsToMove()), Builder.valueOrDefault(this.replicantLifetime, defaults.getReplicantLifetime()), Builder.valueOrDefault(this.replicationThrottleLimit, defaults.getReplicationThrottleLimit()), Builder.valueOrDefault(this.balancerComputeThreads, defaults.getBalancerComputeThreads()), Builder.valueOrDefault(this.specificDataSourcesToKillUnusedSegmentsIn, defaults.getSpecificDataSourcesToKillUnusedSegmentsIn()), Builder.valueOrDefault(this.dataSourcesToNotKillStalePendingSegmentsIn, defaults.getDataSourcesToNotKillStalePendingSegmentsIn()), Builder.valueOrDefault(this.maxSegmentsInNodeLoadingQueue, defaults.getMaxSegmentsInNodeLoadingQueue()), Builder.valueOrDefault(this.decommissioningNodes, defaults.getDecommissioningNodes()), Builder.valueOrDefault(this.decommissioningMaxPercentOfMaxSegmentsToMove, defaults.getDecommissioningMaxPercentOfMaxSegmentsToMove()), Builder.valueOrDefault(this.pauseCoordination, defaults.getPauseCoordination()), Builder.valueOrDefault(this.replicateAfterLoadTimeout, defaults.getReplicateAfterLoadTimeout()), Builder.valueOrDefault(this.maxNonPrimaryReplicantsToLoad, defaults.getMaxNonPrimaryReplicantsToLoad()), Builder.valueOrDefault(this.useRoundRobinSegmentAssignment, defaults.isUseRoundRobinSegmentAssignment()), Builder.valueOrDefault(this.smartSegmentLoading, defaults.isSmartSegmentLoading()), Builder.valueOrDefault(this.debugDimensions, defaults.getDebugDimensions()));
        }
    }

    private static class Defaults {
        static final long LEADING_MILLIS_BEFORE_MARK_UNUSED = TimeUnit.MINUTES.toMillis(15L);
        static final long MERGE_BYTES_LIMIT = 524288000L;
        static final int MERGE_SEGMENTS_LIMIT = 100;
        static final int MAX_SEGMENTS_TO_MOVE = 100;
        static final int REPLICANT_LIFETIME = 15;
        static final int REPLICATION_THROTTLE_LIMIT = 500;
        static final int BALANCER_COMPUTE_THREADS = 1;
        static final boolean EMIT_BALANCING_STATS = false;
        static final int MAX_SEGMENTS_IN_NODE_LOADING_QUEUE = 500;
        static final int DECOMMISSIONING_MAX_SEGMENTS_TO_MOVE_PERCENT = 70;
        static final boolean PAUSE_COORDINATION = false;
        static final boolean REPLICATE_AFTER_LOAD_TIMEOUT = false;
        static final int MAX_NON_PRIMARY_REPLICANTS_TO_LOAD = Integer.MAX_VALUE;
        static final boolean USE_ROUND_ROBIN_ASSIGNMENT = true;
        static final boolean SMART_SEGMENT_LOADING = true;

        private Defaults() {
        }
    }
}

