/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.joda.time.DateTime;

public class DataSourceCompactionConfigAuditEntry {
    private final GlobalCompactionConfig globalConfig;
    private final DataSourceCompactionConfig compactionConfig;
    private final AuditInfo auditInfo;
    private final DateTime auditTime;

    @JsonCreator
    public DataSourceCompactionConfigAuditEntry(@JsonProperty(value="globalConfig") GlobalCompactionConfig globalConfig, @JsonProperty(value="compactionConfig") DataSourceCompactionConfig compactionConfig, @JsonProperty(value="auditInfo") AuditInfo auditInfo, @JsonProperty(value="auditTime") DateTime auditTime) {
        this.globalConfig = globalConfig;
        this.compactionConfig = compactionConfig;
        this.auditInfo = auditInfo;
        this.auditTime = auditTime;
    }

    @JsonProperty
    public GlobalCompactionConfig getGlobalConfig() {
        return this.globalConfig;
    }

    @JsonProperty
    public DataSourceCompactionConfig getCompactionConfig() {
        return this.compactionConfig;
    }

    @JsonProperty
    public AuditInfo getAuditInfo() {
        return this.auditInfo;
    }

    @JsonProperty
    public DateTime getAuditTime() {
        return this.auditTime;
    }

    public static class GlobalCompactionConfig {
        private final double compactionTaskSlotRatio;
        private final int maxCompactionTaskSlots;
        private final boolean useAutoScaleSlots;

        @JsonCreator
        public GlobalCompactionConfig(@JsonProperty(value="compactionTaskSlotRatio") double compactionTaskSlotRatio, @JsonProperty(value="maxCompactionTaskSlots") int maxCompactionTaskSlots, @JsonProperty(value="useAutoScaleSlots") boolean useAutoScaleSlots) {
            this.compactionTaskSlotRatio = compactionTaskSlotRatio;
            this.maxCompactionTaskSlots = maxCompactionTaskSlots;
            this.useAutoScaleSlots = useAutoScaleSlots;
        }

        @JsonProperty
        public double getCompactionTaskSlotRatio() {
            return this.compactionTaskSlotRatio;
        }

        @JsonProperty
        public int getMaxCompactionTaskSlots() {
            return this.maxCompactionTaskSlots;
        }

        @JsonProperty
        public boolean isUseAutoScaleSlots() {
            return this.useAutoScaleSlots;
        }

        @JsonIgnore
        public boolean hasSameConfig(CoordinatorCompactionConfig coordinatorCompactionConfig) {
            return this.useAutoScaleSlots == coordinatorCompactionConfig.isUseAutoScaleSlots() && this.compactionTaskSlotRatio == coordinatorCompactionConfig.getCompactionTaskSlotRatio() && coordinatorCompactionConfig.getMaxCompactionTaskSlots() == this.maxCompactionTaskSlots;
        }
    }
}

