/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class SegmentCountsPerInterval {
    private final Map<String, Object2IntMap<Interval>> datasourceIntervalToSegmentCount = new HashMap<String, Object2IntMap<Interval>>();
    private final Object2IntMap<Interval> intervalToTotalSegmentCount = new Object2IntOpenHashMap();

    public void addSegment(DataSegment segment) {
        this.updateCountInInterval(segment, 1);
    }

    public void removeSegment(DataSegment segment) {
        this.updateCountInInterval(segment, -1);
    }

    public Object2IntMap<Interval> getIntervalToSegmentCount(String datasource) {
        return this.datasourceIntervalToSegmentCount.getOrDefault(datasource, (Object2IntMap<Interval>)Object2IntMaps.emptyMap());
    }

    public Object2IntMap<Interval> getIntervalToTotalSegmentCount() {
        return this.intervalToTotalSegmentCount;
    }

    private void updateCountInInterval(DataSegment segment, int delta) {
        this.intervalToTotalSegmentCount.mergeInt((Object)segment.getInterval(), delta, Integer::sum);
        this.datasourceIntervalToSegmentCount.computeIfAbsent(segment.getDataSource(), ds -> new Object2IntOpenHashMap()).mergeInt((Object)segment.getInterval(), delta, Integer::sum);
    }
}

