/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.balancer;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.client.ServerView;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordinator.balancer.BalancerStrategy;
import org.apache.druid.server.coordinator.balancer.BalancerStrategyFactory;
import org.apache.druid.server.coordinator.balancer.CachingCostBalancerStrategy;
import org.apache.druid.server.coordinator.balancer.CachingCostBalancerStrategyConfig;
import org.apache.druid.server.coordinator.balancer.ClusterCostCache;
import org.apache.druid.server.coordinator.balancer.CostBalancerStrategy;
import org.apache.druid.timeline.DataSegment;

public class CachingCostBalancerStrategyFactory
implements BalancerStrategyFactory {
    private static final EmittingLogger LOG = new EmittingLogger(CachingCostBalancerStrategyFactory.class);
    private final ExecutorService executor = Execs.singleThreaded((String)"CachingCostBalancerStrategy-executor");
    private final ClusterCostCache.Builder clusterCostCacheBuilder = ClusterCostCache.builder();
    private final CountDownLatch initialized = new CountDownLatch(1);
    private final CachingCostBalancerStrategyConfig config;

    @JsonCreator
    public CachingCostBalancerStrategyFactory(@JacksonInject ServerInventoryView serverInventoryView, @JacksonInject Lifecycle lifecycle, @JacksonInject CachingCostBalancerStrategyConfig config) throws Exception {
        this.config = config;
        lifecycle.addMaybeStartManagedInstance((Object)this);
        serverInventoryView.registerSegmentCallback(this.executor, new ServerView.SegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                if (server.isSegmentReplicationTarget()) {
                    CachingCostBalancerStrategyFactory.this.clusterCostCacheBuilder.addSegment(server.getName(), segment);
                }
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                if (server.isSegmentReplicationTarget()) {
                    CachingCostBalancerStrategyFactory.this.clusterCostCacheBuilder.removeSegment(server.getName(), segment);
                }
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentViewInitialized() {
                CachingCostBalancerStrategyFactory.this.initialized.countDown();
                return ServerView.CallbackAction.CONTINUE;
            }
        });
        serverInventoryView.registerServerRemovedCallback(this.executor, server -> {
            if (server.isSegmentReplicationTarget()) {
                this.clusterCostCacheBuilder.removeServer(server.getName());
            }
            return ServerView.CallbackAction.CONTINUE;
        });
    }

    @LifecycleStart
    public void start() {
    }

    @LifecycleStop
    public void stop() {
        this.executor.shutdownNow();
    }

    private boolean isInitialized() {
        return this.initialized.getCount() == 0L;
    }

    @Override
    public BalancerStrategy createBalancerStrategy(ListeningExecutorService exec) {
        LOG.warn("'cachingCost' balancer strategy has been deprecated as it can lead to unbalanced clusters. Use 'cost' strategy instead.", new Object[0]);
        if (!this.isInitialized() && this.config.isAwaitInitialization()) {
            try {
                long startMillis = System.currentTimeMillis();
                LOG.info("Waiting for segment view initialization before creating CachingCostBalancerStrategy.", new Object[0]);
                this.initialized.await();
                LOG.info("Segment view initialized in [%,d] ms.", new Object[]{System.currentTimeMillis() - startMillis});
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e, "Segment view initialization has been interrupted.", new Object[0]);
                Thread.currentThread().interrupt();
            }
        }
        if (this.isInitialized()) {
            try {
                CompletableFuture<CachingCostBalancerStrategy> future = CompletableFuture.supplyAsync(() -> new CachingCostBalancerStrategy(this.clusterCostCacheBuilder.build(), exec), this.executor);
                try {
                    return future.get();
                }
                catch (CancellationException e) {
                    LOG.error("CachingCostBalancerStrategy creation has been cancelled", new Object[0]);
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e, "Failed to create CachingCostBalancerStrategy", new Object[0]);
                }
                catch (InterruptedException e) {
                    LOG.error("CachingCostBalancerStrategy creation has been interrupted", new Object[0]);
                    Thread.currentThread().interrupt();
                }
            }
            catch (RejectedExecutionException e) {
                LOG.error("CachingCostBalancerStrategy creation has been rejected", new Object[0]);
            }
        } else {
            LOG.error("CachingCostBalancerStrategy could not be created as serverView is not initialized yet", new Object[0]);
        }
        LOG.info("Fallback to CostBalancerStrategy", new Object[0]);
        return new CostBalancerStrategy(exec);
    }
}

