/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import java.util.Set;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.balancer.TierSegmentBalancer;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.loading.SegmentLoadingConfig;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;

public class BalanceSegments
implements CoordinatorDuty {
    private static final EmittingLogger log = new EmittingLogger(BalanceSegments.class);

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        if (params.getUsedSegments().isEmpty()) {
            log.info("Skipping balance as there are no used segments.", new Object[0]);
            return params;
        }
        DruidCluster cluster = params.getDruidCluster();
        SegmentLoadingConfig loadingConfig = params.getSegmentLoadingConfig();
        int maxSegmentsToMove = loadingConfig.getMaxSegmentsToMove();
        if (maxSegmentsToMove <= 0) {
            log.info("Skipping balance as maxSegmentsToMove is [%d].", new Object[]{maxSegmentsToMove});
            return params;
        }
        log.info("Balancing segments in tiers [%s] with maxSegmentsToMove=[%d], maxLifetime=[%d].", new Object[]{cluster.getTierNames(), maxSegmentsToMove, loadingConfig.getMaxLifetimeInLoadQueue()});
        cluster.getHistoricals().forEach((tier, servers) -> new TierSegmentBalancer((String)tier, (Set<ServerHolder>)servers, params).run());
        CoordinatorRunStats runStats = params.getCoordinatorStats();
        params.getBalancerStrategy().getAndResetStats().forEachStat(runStats::add);
        return params;
    }
}

