/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.loading.StrategicSegmentAssigner;
import org.apache.druid.server.coordinator.rules.BroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;

public class RunRules
implements CoordinatorDuty {
    private static final EmittingLogger log = new EmittingLogger(RunRules.class);
    private static final int MAX_MISSING_RULES = 10;

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        DruidCluster cluster = params.getDruidCluster();
        if (cluster.isEmpty()) {
            log.warn("Cluster has no servers. Not running any rules.", new Object[0]);
            return params;
        }
        ImmutableSet<DataSegment> overshadowed = params.getDataSourcesSnapshot().getOvershadowedSegments();
        TreeSet<DataSegment> usedSegments = params.getUsedSegments();
        log.info("Applying retention rules on [%,d] used segments, skipping [%,d] overshadowed segments.", new Object[]{usedSegments.size(), overshadowed.size()});
        StrategicSegmentAssigner segmentAssigner = params.getSegmentAssigner();
        MetadataRuleManager databaseRuleManager = params.getDatabaseRuleManager();
        int missingRules = 0;
        DateTime now = DateTimes.nowUtc();
        ArrayList segmentsWithMissingRules = Lists.newArrayListWithCapacity((int)10);
        for (DataSegment segment : usedSegments) {
            if (overshadowed.contains(segment)) continue;
            List<Rule> rules = databaseRuleManager.getRulesWithDefault(segment.getDataSource());
            boolean foundMatchingRule = false;
            for (Rule rule : rules) {
                if (!rule.appliesTo(segment, now)) continue;
                rule.run(segment, segmentAssigner);
                foundMatchingRule = true;
                break;
            }
            if (foundMatchingRule) continue;
            if (segmentsWithMissingRules.size() < 10) {
                segmentsWithMissingRules.add(segment.getId());
            }
            ++missingRules;
        }
        if (!segmentsWithMissingRules.isEmpty()) {
            log.makeAlert("Unable to find matching rules!", new Object[0]).addData("segmentsWithMissingRulesCount", (Object)missingRules).addData("segmentsWithMissingRules", (Object)segmentsWithMissingRules).emit();
        }
        return params.buildFromExisting().withBroadcastDatasources(this.getBroadcastDatasources(params)).build();
    }

    private Set<String> getBroadcastDatasources(DruidCoordinatorRuntimeParams params) {
        Set<String> broadcastDatasources = params.getDataSourcesSnapshot().getDataSourcesMap().values().stream().map(ImmutableDruidDataSource::getName).filter(datasource -> this.isBroadcastDatasource((String)datasource, params)).collect(Collectors.toSet());
        if (!broadcastDatasources.isEmpty()) {
            log.info("Found broadcast datasources [%s] which will not participate in balancing.", new Object[]{broadcastDatasources});
        }
        return broadcastDatasources;
    }

    private boolean isBroadcastDatasource(String datasource, DruidCoordinatorRuntimeParams params) {
        return params.getDatabaseRuleManager().getRulesWithDefault(datasource).stream().anyMatch(rule -> rule instanceof BroadcastDistributionRule);
    }
}

