/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReplicationThrottler {
    private final int replicationThrottleLimit;
    private final int maxReplicaAssignmentsInRun;
    private final Map<String, Integer> tierToNumAssigned = new HashMap<String, Integer>();
    private final Set<String> tiersLoadingReplicas = new HashSet<String>();
    private int totalReplicasAssignedInRun;

    public ReplicationThrottler(Set<String> tiersLoadingReplicas, int replicationThrottleLimit, int maxReplicaAssignmentsInRun) {
        this.replicationThrottleLimit = replicationThrottleLimit;
        this.maxReplicaAssignmentsInRun = maxReplicaAssignmentsInRun;
        this.totalReplicasAssignedInRun = 0;
        if (tiersLoadingReplicas != null) {
            this.tiersLoadingReplicas.addAll(tiersLoadingReplicas);
        }
    }

    public boolean isTierLoadingReplicas(String tier) {
        return this.tiersLoadingReplicas.contains(tier);
    }

    public boolean canAssignReplica(String tier) {
        return !this.tiersLoadingReplicas.contains(tier) && this.totalReplicasAssignedInRun < this.maxReplicaAssignmentsInRun && this.tierToNumAssigned.computeIfAbsent(tier, t -> 0) < this.replicationThrottleLimit;
    }

    public void incrementAssignedReplicas(String tier) {
        ++this.totalReplicasAssignedInRun;
        this.tierToNumAssigned.compute(tier, (t, count) -> count == null ? 1 : count + 1);
    }
}

