/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import com.google.inject.Inject;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.loading.LoadPeonCallback;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.LoadQueueTaskMaster;
import org.apache.druid.server.coordinator.loading.SegmentAction;
import org.apache.druid.timeline.DataSegment;

public class SegmentLoadQueueManager {
    private static final Logger log = new Logger(SegmentLoadQueueManager.class);
    private final LoadQueueTaskMaster taskMaster;
    private final ServerInventoryView serverInventoryView;
    private final SegmentsMetadataManager segmentsMetadataManager;

    @Inject
    public SegmentLoadQueueManager(ServerInventoryView serverInventoryView, SegmentsMetadataManager segmentsMetadataManager, LoadQueueTaskMaster taskMaster) {
        this.serverInventoryView = serverInventoryView;
        this.segmentsMetadataManager = segmentsMetadataManager;
        this.taskMaster = taskMaster;
    }

    public boolean loadSegment(DataSegment segment, ServerHolder server, SegmentAction action) {
        try {
            if (!server.startOperation(action, segment)) {
                return false;
            }
            server.getPeon().loadSegment(segment, action, null);
            return true;
        }
        catch (Exception e) {
            server.cancelOperation(action, segment);
            String serverName = server.getServer().getName();
            log.error((Throwable)e, "Error while loading segment[%s] on server[%s]", new Object[]{segment.getId(), serverName});
            return false;
        }
    }

    public boolean dropSegment(DataSegment segment, ServerHolder server) {
        try {
            if (server.startOperation(SegmentAction.DROP, segment)) {
                server.getPeon().dropSegment(segment, null);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            server.cancelOperation(SegmentAction.DROP, segment);
            String serverName = server.getServer().getName();
            log.error((Throwable)e, "Error while dropping segment[%s] from server[%s]", new Object[]{segment.getId(), serverName});
            return false;
        }
    }

    public boolean moveSegment(DataSegment segment, ServerHolder serverA, ServerHolder serverB) {
        LoadQueuePeon peonA = serverA.getPeon();
        LoadPeonCallback moveFinishCallback = success -> peonA.unmarkSegmentToDrop(segment);
        if (!serverA.startOperation(SegmentAction.MOVE_FROM, segment)) {
            return false;
        }
        if (!serverB.startOperation(SegmentAction.MOVE_TO, segment)) {
            serverA.cancelOperation(SegmentAction.MOVE_FROM, segment);
            return false;
        }
        peonA.markSegmentToDrop(segment);
        LoadQueuePeon peonB = serverB.getPeon();
        String serverNameB = serverB.getServer().getName();
        try {
            peonB.loadSegment(segment, SegmentAction.MOVE_TO, (boolean success) -> {
                if (success && !peonA.getSegmentsToDrop().contains(segment) && (this.taskMaster.isHttpLoading() || this.serverInventoryView.isSegmentLoadedByServer(serverNameB, segment))) {
                    peonA.unmarkSegmentToDrop(segment);
                    peonA.dropSegment(segment, moveFinishCallback);
                } else {
                    moveFinishCallback.execute(success);
                }
            });
        }
        catch (Exception e) {
            serverA.cancelOperation(SegmentAction.MOVE_FROM, segment);
            serverB.cancelOperation(SegmentAction.MOVE_TO, segment);
            moveFinishCallback.execute(false);
            log.error((Throwable)e, "Error while moving segment[%s] to server[%s]", new Object[]{segment.getId(), serverNameB});
            return false;
        }
        return true;
    }

    public boolean deleteSegment(DataSegment segment) {
        return this.segmentsMetadataManager.markSegmentAsUnused(segment.getId());
    }
}

