/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;

public class SegmentLoadingConfig {
    private static final Logger log = new Logger(SegmentLoadingConfig.class);
    private final int maxSegmentsInLoadQueue;
    private final int replicationThrottleLimit;
    private final int maxReplicaAssignmentsInRun;
    private final int maxLifetimeInLoadQueue;
    private final int maxSegmentsToMove;
    private final int percentDecommSegmentsToMove;
    private final boolean useRoundRobinSegmentAssignment;

    public static SegmentLoadingConfig create(CoordinatorDynamicConfig dynamicConfig, int numUsedSegments) {
        if (dynamicConfig.isSmartSegmentLoading()) {
            int throttlePercentage = 2;
            int replicationThrottleLimit = Math.max(100, numUsedSegments * 2 / 100);
            int maxSegmentsToMove = Math.min(1000, replicationThrottleLimit);
            log.info("Smart segment loading is enabled. Recomputed replicationThrottleLimit [%,d] (%d%% of used segments [%,d]) and maxSegmentsToMove [%,d].", new Object[]{replicationThrottleLimit, 2, numUsedSegments, maxSegmentsToMove});
            return new SegmentLoadingConfig(0, replicationThrottleLimit, Integer.MAX_VALUE, 60, maxSegmentsToMove, 100, true);
        }
        return new SegmentLoadingConfig(dynamicConfig.getMaxSegmentsInNodeLoadingQueue(), dynamicConfig.getReplicationThrottleLimit(), dynamicConfig.getMaxNonPrimaryReplicantsToLoad(), dynamicConfig.getReplicantLifetime(), dynamicConfig.getMaxSegmentsToMove(), dynamicConfig.getDecommissioningMaxPercentOfMaxSegmentsToMove(), dynamicConfig.isUseRoundRobinSegmentAssignment());
    }

    private SegmentLoadingConfig(int maxSegmentsInLoadQueue, int replicationThrottleLimit, int maxReplicaAssignmentsInRun, int maxLifetimeInLoadQueue, int maxSegmentsToMove, int percentDecommSegmentsToMove, boolean useRoundRobinSegmentAssignment) {
        this.maxSegmentsInLoadQueue = maxSegmentsInLoadQueue;
        this.replicationThrottleLimit = replicationThrottleLimit;
        this.maxReplicaAssignmentsInRun = maxReplicaAssignmentsInRun;
        this.maxLifetimeInLoadQueue = maxLifetimeInLoadQueue;
        this.maxSegmentsToMove = maxSegmentsToMove;
        this.percentDecommSegmentsToMove = percentDecommSegmentsToMove;
        this.useRoundRobinSegmentAssignment = useRoundRobinSegmentAssignment;
    }

    public int getMaxSegmentsInLoadQueue() {
        return this.maxSegmentsInLoadQueue;
    }

    public int getMaxSegmentsToMove() {
        return this.maxSegmentsToMove;
    }

    public int getReplicationThrottleLimit() {
        return this.replicationThrottleLimit;
    }

    public boolean isUseRoundRobinSegmentAssignment() {
        return this.useRoundRobinSegmentAssignment;
    }

    public int getMaxLifetimeInLoadQueue() {
        return this.maxLifetimeInLoadQueue;
    }

    public int getMaxReplicaAssignmentsInRun() {
        return this.maxReplicaAssignmentsInRun;
    }

    public int getPercentDecommSegmentsToMove() {
        return this.percentDecommSegmentsToMove;
    }
}

