/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.common.config.Configs;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.coordinator.rules.SegmentActionHandler;
import org.apache.druid.timeline.DataSegment;

public abstract class LoadRule
implements Rule {
    private final Map<String, Integer> tieredReplicants;
    private final boolean useDefaultTierForNull;

    protected LoadRule(Map<String, Integer> tieredReplicants, Boolean useDefaultTierForNull) {
        this.useDefaultTierForNull = Configs.valueOrDefault((Boolean)useDefaultTierForNull, (boolean)true);
        this.tieredReplicants = LoadRule.handleNullTieredReplicants(tieredReplicants, this.useDefaultTierForNull);
        LoadRule.validateTieredReplicants(this.tieredReplicants);
    }

    @JsonProperty
    public Map<String, Integer> getTieredReplicants() {
        return this.tieredReplicants;
    }

    @JsonProperty
    public boolean useDefaultTierForNull() {
        return this.useDefaultTierForNull;
    }

    @Override
    public void run(DataSegment segment, SegmentActionHandler handler) {
        handler.replicateSegment(segment, this.getTieredReplicants());
    }

    private static Map<String, Integer> handleNullTieredReplicants(Map<String, Integer> tieredReplicants, boolean useDefaultTierForNull) {
        if (useDefaultTierForNull) {
            return (Map)Configs.valueOrDefault(tieredReplicants, (Object)ImmutableMap.of((Object)"_default_tier", (Object)2));
        }
        return (Map)Configs.valueOrDefault(tieredReplicants, (Object)ImmutableMap.of());
    }

    private static void validateTieredReplicants(Map<String, Integer> tieredReplicants) {
        for (Map.Entry<String, Integer> entry : tieredReplicants.entrySet()) {
            if (entry.getValue() == null) {
                throw InvalidInput.exception((String)"Invalid number of replicas for tier [%s]. Value must not be null.", (Object[])new Object[]{entry.getKey()});
            }
            if (entry.getValue() >= 0) continue;
            throw InvalidInput.exception((String)"Invalid number of replicas for tier [%s]. Value [%d] must be positive.", (Object[])new Object[]{entry.getKey(), entry.getValue()});
        }
    }

    public int getNumReplicants(String tier) {
        Integer retVal = this.getTieredReplicants().get(tier);
        return retVal == null ? 0 : retVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadRule loadRule = (LoadRule)o;
        return this.useDefaultTierForNull == loadRule.useDefaultTierForNull && Objects.equals(this.tieredReplicants, loadRule.tieredReplicants);
    }

    public int hashCode() {
        return Objects.hash(this.tieredReplicants, this.useDefaultTierForNull);
    }
}

