/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.stats;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.coordinator.stats.CoordinatorStat;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;

@ThreadSafe
public class CoordinatorRunStats {
    private static final CoordinatorRunStats EMPTY_INSTANCE = new CoordinatorRunStats(){

        @Override
        public void add(CoordinatorStat stat, RowKey rowKey, long value) {
            throw new UnsupportedOperationException("Cannot add stats to empty CoordinatorRunStats instance");
        }

        @Override
        public void updateMax(CoordinatorStat stat, RowKey rowKey, long value) {
            throw new UnsupportedOperationException("Cannot add stats to empty CoordinatorRunStats instance");
        }
    };
    private final ConcurrentHashMap<RowKey, Object2LongOpenHashMap<CoordinatorStat>> allStats = new ConcurrentHashMap();
    private final Map<Dimension, String> debugDimensions = new HashMap<Dimension, String>();

    public static CoordinatorRunStats empty() {
        return EMPTY_INSTANCE;
    }

    public CoordinatorRunStats() {
        this(null);
    }

    public CoordinatorRunStats(Map<Dimension, String> debugDimensions) {
        if (debugDimensions != null) {
            this.debugDimensions.putAll(debugDimensions);
        }
    }

    public long getSegmentStat(CoordinatorStat stat, String tier, String datasource) {
        return this.get(stat, RowKey.with(Dimension.DATASOURCE, datasource).and(Dimension.TIER, tier));
    }

    public long get(CoordinatorStat stat) {
        return this.get(stat, RowKey.EMPTY);
    }

    public long get(CoordinatorStat stat, RowKey rowKey) {
        Object2LongOpenHashMap<CoordinatorStat> statValues = this.allStats.get(rowKey);
        return statValues == null ? 0L : statValues.getLong((Object)stat);
    }

    public void forEachStat(StatHandler handler) {
        this.allStats.forEach((rowKey, stats) -> stats.object2LongEntrySet().fastForEach(stat -> handler.handle((CoordinatorStat)stat.getKey(), (RowKey)rowKey, stat.getLongValue())));
    }

    public String buildStatsTable() {
        StringBuilder statsTable = new StringBuilder();
        AtomicInteger hiddenStats = new AtomicInteger(0);
        AtomicInteger totalStats = new AtomicInteger();
        this.allStats.forEach((rowKey, statMap) -> {
            EnumMap levelToStats = new EnumMap(CoordinatorStat.Level.class);
            statMap.object2LongEntrySet().fastForEach(stat -> levelToStats.computeIfAbsent(((CoordinatorStat)stat.getKey()).getLevel(), l -> new HashMap()).put(stat.getKey(), stat.getLongValue()));
            Map errorStats = levelToStats.getOrDefault((Object)CoordinatorStat.Level.ERROR, Collections.emptyMap());
            totalStats.addAndGet(errorStats.size());
            if (!errorStats.isEmpty()) {
                statsTable.append(StringUtils.format((String)"\nError: %s ==> %s", (Object[])new Object[]{rowKey, errorStats}));
            }
            Map infoStats = levelToStats.getOrDefault((Object)CoordinatorStat.Level.INFO, Collections.emptyMap());
            totalStats.addAndGet(infoStats.size());
            if (!infoStats.isEmpty()) {
                statsTable.append(StringUtils.format((String)"\nInfo : %s ==> %s", (Object[])new Object[]{rowKey, infoStats}));
            }
            Map debugStats = levelToStats.getOrDefault((Object)CoordinatorStat.Level.DEBUG, Collections.emptyMap());
            totalStats.addAndGet(debugStats.size());
            if (!debugStats.isEmpty() && this.hasDebugDimension((RowKey)rowKey)) {
                statsTable.append(StringUtils.format((String)"\nDebug: %s ==> %s", (Object[])new Object[]{rowKey, debugStats}));
            } else {
                hiddenStats.addAndGet(debugStats.size());
            }
        });
        if (hiddenStats.get() > 0) {
            statsTable.append(StringUtils.format((String)"\nDebug: %d hidden stats. Set 'debugDimensions' to see these.", (Object[])new Object[]{hiddenStats.get()}));
        }
        if (totalStats.get() > 0) {
            statsTable.append(StringUtils.format((String)"\nTOTAL: %d stats for %d dimension keys", (Object[])new Object[]{totalStats.get(), this.rowCount()}));
        }
        return statsTable.toString();
    }

    public boolean hasStat(CoordinatorStat stat) {
        for (Object2LongOpenHashMap<CoordinatorStat> statValues : this.allStats.values()) {
            if (!statValues.containsKey((Object)stat)) continue;
            return true;
        }
        return false;
    }

    public int rowCount() {
        return this.allStats.size();
    }

    public void clear() {
        this.allStats.clear();
    }

    public void add(CoordinatorStat stat, long value) {
        this.add(stat, RowKey.EMPTY, value);
    }

    public void add(CoordinatorStat stat, RowKey rowKey, long value) {
        this.allStats.computeIfAbsent(rowKey, d -> new Object2LongOpenHashMap()).addTo((Object)stat, value);
    }

    public void addToSegmentStat(CoordinatorStat stat, String tier, String datasource, long value) {
        RowKey rowKey = RowKey.with(Dimension.TIER, tier).and(Dimension.DATASOURCE, datasource);
        this.add(stat, rowKey, value);
    }

    public void updateMax(CoordinatorStat stat, RowKey rowKey, long value) {
        this.allStats.computeIfAbsent(rowKey, d -> new Object2LongOpenHashMap()).mergeLong((Object)stat, value, Math::max);
    }

    public CoordinatorRunStats getSnapshotAndReset() {
        CoordinatorRunStats snapshot = new CoordinatorRunStats(this.debugDimensions);
        HashSet keys = new HashSet(this.allStats.keySet());
        for (RowKey key : keys) {
            snapshot.allStats.put(key, this.allStats.remove(key));
        }
        return snapshot;
    }

    private boolean hasDebugDimension(RowKey rowKey) {
        if (this.debugDimensions.isEmpty()) {
            return false;
        }
        for (Map.Entry<Dimension, String> entry : rowKey.getValues().entrySet()) {
            String expectedValue = this.debugDimensions.get((Object)entry.getKey());
            if (!Objects.equals(expectedValue, entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public static interface StatHandler {
        public void handle(CoordinatorStat var1, RowKey var2, long var3);
    }
}

