/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.client.SegmentLoadInfo;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.UnknownSegmentIdsException;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.http.InventoryViewUtils;
import org.apache.druid.server.http.security.DatasourceResourceFilter;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.TimelineLookup;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

@Path(value="/druid/coordinator/v1/datasources")
public class DataSourcesResource {
    private static final Logger log = new Logger(DataSourcesResource.class);
    private static final long DEFAULT_LOADSTATUS_INTERVAL_OFFSET = 1209600000L;
    private final CoordinatorServerView serverInventoryView;
    private final SegmentsMetadataManager segmentsMetadataManager;
    private final MetadataRuleManager metadataRuleManager;
    private final IndexingServiceClient indexingServiceClient;
    private final AuthorizerMapper authorizerMapper;
    private final DruidCoordinator coordinator;

    @Inject
    public DataSourcesResource(CoordinatorServerView serverInventoryView, SegmentsMetadataManager segmentsMetadataManager, MetadataRuleManager metadataRuleManager, @Nullable IndexingServiceClient indexingServiceClient, AuthorizerMapper authorizerMapper, DruidCoordinator coordinator) {
        this.serverInventoryView = serverInventoryView;
        this.segmentsMetadataManager = segmentsMetadataManager;
        this.metadataRuleManager = metadataRuleManager;
        this.indexingServiceClient = indexingServiceClient;
        this.authorizerMapper = authorizerMapper;
        this.coordinator = coordinator;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getQueryableDataSources(@QueryParam(value="full") @Nullable String full, @QueryParam(value="simple") @Nullable String simple, @Context HttpServletRequest req) {
        Response.ResponseBuilder builder = Response.ok();
        SortedSet<ImmutableDruidDataSource> datasources = InventoryViewUtils.getSecuredDataSources(req, this.serverInventoryView, this.authorizerMapper);
        SequencedCollection<ImmutableDruidDataSource> entity = full != null ? datasources : (simple != null ? datasources.stream().map(this::makeSimpleDatasource).collect(Collectors.toList()) : datasources.stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        return builder.entity(entity).build();
    }

    @GET
    @Path(value="/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDataSource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        if (full != null) {
            return Response.ok((Object)dataSource).build();
        }
        return Response.ok(this.getSimpleDatasource(dataSourceName)).build();
    }

    @POST
    @Path(value="/{dataSourceName}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markAsUsedAllNonOvershadowedSegments(@PathParam(value="dataSourceName") String dataSourceName) {
        MarkSegments markSegments = () -> this.segmentsMetadataManager.markAsUsedAllNonOvershadowedSegmentsInDataSource(dataSourceName);
        return DataSourcesResource.doMarkSegments("markAsUsedAllNonOvershadowedSegments", dataSourceName, markSegments);
    }

    @POST
    @Path(value="/{dataSourceName}/markUsed")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markAsUsedNonOvershadowedSegments(@PathParam(value="dataSourceName") String dataSourceName, MarkDataSourceSegmentsPayload payload) {
        MarkSegments markSegments = () -> {
            Interval interval = payload.getInterval();
            if (interval != null) {
                return this.segmentsMetadataManager.markAsUsedNonOvershadowedSegmentsInInterval(dataSourceName, interval);
            }
            Set<String> segmentIds = payload.getSegmentIds();
            return this.segmentsMetadataManager.markAsUsedNonOvershadowedSegments(dataSourceName, segmentIds);
        };
        return this.doMarkSegmentsWithPayload("markAsUsedNonOvershadowedSegments", dataSourceName, payload, markSegments);
    }

    @POST
    @Path(value="/{dataSourceName}/markUnused")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response markSegmentsAsUnused(@PathParam(value="dataSourceName") String dataSourceName, MarkDataSourceSegmentsPayload payload) {
        MarkSegments markSegments = () -> {
            Interval interval = payload.getInterval();
            if (interval != null) {
                return this.segmentsMetadataManager.markAsUnusedSegmentsInInterval(dataSourceName, interval);
            }
            Set segmentIds = payload.getSegmentIds().stream().map(idStr -> SegmentId.tryParse((String)dataSourceName, (String)idStr)).filter(Objects::nonNull).collect(Collectors.toSet());
            return this.segmentsMetadataManager.markSegmentsAsUnused(segmentIds.stream().filter(segmentId -> segmentId.getDataSource().equals(dataSourceName)).collect(Collectors.toSet()));
        };
        return this.doMarkSegmentsWithPayload("markSegmentsAsUnused", dataSourceName, payload, markSegments);
    }

    private Response doMarkSegmentsWithPayload(String method, String dataSourceName, MarkDataSourceSegmentsPayload payload, MarkSegments markSegments) {
        if (payload == null || !payload.isValid()) {
            log.warn("Invalid request payload: [%s]", new Object[]{payload});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid request payload, either interval or segmentIds array must be specified").build();
        }
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        return DataSourcesResource.doMarkSegments(method, dataSourceName, markSegments);
    }

    private static Response logAndCreateDataSourceNotFoundResponse(String dataSourceName) {
        log.warn("datasource not found [%s]", new Object[]{dataSourceName});
        return Response.noContent().build();
    }

    private static Response doMarkSegments(String method, String dataSourceName, MarkSegments markSegments) {
        try {
            int numChangedSegments = markSegments.markSegments();
            return Response.ok((Object)ImmutableMap.of((Object)"numChangedSegments", (Object)numChangedSegments)).build();
        }
        catch (UnknownSegmentIdsException e) {
            log.warn("Segment ids %s are not found", new Object[]{e.getUnknownSegmentIds()});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"message", (Object)e.getMessage())).build();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error occurred during [%s] call, data source: [%s]", new Object[]{method, dataSourceName});
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Exception occurred.", (Object)"message", (Object)Throwables.getRootCause((Throwable)e).toString())).build();
        }
    }

    @DELETE
    @Deprecated
    @Path(value="/{dataSourceName}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    public Response markAsUnusedAllSegmentsOrKillUnusedSegmentsInInterval(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="kill") String kill, @QueryParam(value="interval") String interval) {
        boolean killSegments;
        if (this.indexingServiceClient == null) {
            return Response.ok((Object)ImmutableMap.of((Object)"error", (Object)"no indexing service found")).build();
        }
        boolean bl = killSegments = kill != null && Boolean.valueOf(kill) != false;
        if (killSegments) {
            return this.killUnusedSegmentsInInterval(dataSourceName, interval);
        }
        MarkSegments markSegments = () -> this.segmentsMetadataManager.markAsUnusedAllSegmentsInDataSource(dataSourceName);
        return DataSourcesResource.doMarkSegments("markAsUnusedAllSegments", dataSourceName, markSegments);
    }

    @DELETE
    @Path(value="/{dataSourceName}/intervals/{interval}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    public Response killUnusedSegmentsInInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval) {
        if (this.indexingServiceClient == null) {
            return Response.ok((Object)ImmutableMap.of((Object)"error", (Object)"no indexing service found")).build();
        }
        if (StringUtils.contains((String)interval, (char)'_')) {
            log.warn("Use interval with '/', not '_': [%s] given", new Object[]{interval});
        }
        Interval theInterval = Intervals.of((String)interval.replace('_', '/'));
        try {
            this.indexingServiceClient.killUnusedSegments("api-issued", dataSourceName, theInterval);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Exception occurred. Are you sure you have an indexing service?", (Object)"message", (Object)e.toString())).build();
        }
    }

    @GET
    @Path(value="/{dataSourceName}/intervals")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getIntervalsWithServedSegmentsOrAllServedSegmentsPerIntervals(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        if (simple == null && full == null) {
            ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
            if (dataSource == null) {
                return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
            }
            Comparator comparator = Comparators.intervalsByStartThenEnd().reversed();
            TreeSet intervals = new TreeSet(comparator);
            dataSource.getSegments().forEach(segment -> intervals.add(segment.getInterval()));
            return Response.ok(intervals).build();
        }
        return this.getServedSegmentsInInterval(dataSourceName, full != null, interval -> true);
    }

    @GET
    @Path(value="/{dataSourceName}/intervals/{interval}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getServedSegmentsInInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        Interval theInterval = Intervals.of((String)interval.replace('_', '/'));
        if (simple == null && full == null) {
            ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
            if (dataSource == null) {
                return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
            }
            TreeSet<SegmentId> segmentIds = new TreeSet<SegmentId>();
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                segmentIds.add(dataSegment.getId());
            }
            return Response.ok(segmentIds).build();
        }
        return this.getServedSegmentsInInterval(dataSourceName, full != null, arg_0 -> ((Interval)theInterval).contains(arg_0));
    }

    @GET
    @Path(value="/{dataSourceName}/loadstatus")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatasourceLoadstatus(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="forceMetadataRefresh") Boolean forceMetadataRefresh, @QueryParam(value="interval") @Nullable String interval, @QueryParam(value="simple") @Nullable String simple, @QueryParam(value="full") @Nullable String full, @QueryParam(value="computeUsingClusterView") @Nullable String computeUsingClusterView) {
        Interval theInterval;
        if (forceMetadataRefresh == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid request. forceMetadataRefresh must be specified").build();
        }
        if (interval == null) {
            long currentTimeInMs = System.currentTimeMillis();
            theInterval = Intervals.utc((long)(currentTimeInMs - 1209600000L), (long)currentTimeInMs);
        } else {
            theInterval = Intervals.of((String)interval.replace('_', '/'));
        }
        Optional<Iterable<DataSegment>> segments = this.segmentsMetadataManager.iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(dataSourceName, theInterval, forceMetadataRefresh);
        if (!segments.isPresent()) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        if (Iterables.size((Iterable)((Iterable)segments.get())) == 0) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)"No used segment found for the given datasource and interval").build();
        }
        if (simple != null) {
            SegmentsLoadStatistics segmentsLoadStatistics = this.computeSegmentLoadStatistics((Iterable)segments.get());
            return Response.ok((Object)ImmutableMap.of((Object)dataSourceName, (Object)segmentsLoadStatistics.getNumUnavailableSegments())).build();
        }
        if (full != null) {
            Map<String, Object2LongMap<String>> segmentLoadMap = this.coordinator.getTierToDatasourceToUnderReplicatedCount((Iterable)segments.get(), computeUsingClusterView != null);
            if (segmentLoadMap.isEmpty()) {
                return Response.serverError().entity((Object)"Coordinator segment replicant lookup is not initialized yet. Try again later.").build();
            }
            return Response.ok(segmentLoadMap).build();
        }
        SegmentsLoadStatistics segmentsLoadStatistics = this.computeSegmentLoadStatistics((Iterable)segments.get());
        return Response.ok((Object)ImmutableMap.of((Object)dataSourceName, (Object)(100.0 * ((double)segmentsLoadStatistics.getNumLoadedSegments() / (double)segmentsLoadStatistics.getNumPublishedSegments())))).build();
    }

    private SegmentsLoadStatistics computeSegmentLoadStatistics(Iterable<DataSegment> segments) {
        Map<SegmentId, SegmentLoadInfo> segmentLoadInfos = this.serverInventoryView.getSegmentLoadInfos();
        int numPublishedSegments = 0;
        int numUnavailableSegments = 0;
        int numLoadedSegments = 0;
        for (DataSegment segment : segments) {
            ++numPublishedSegments;
            if (!segmentLoadInfos.containsKey(segment.getId())) {
                ++numUnavailableSegments;
                continue;
            }
            ++numLoadedSegments;
        }
        return new SegmentsLoadStatistics(numPublishedSegments, numUnavailableSegments, numLoadedSegments);
    }

    private Response getServedSegmentsInInterval(String dataSourceName, boolean full, Predicate<Interval> intervalFilter) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        Comparator comparator = Comparators.intervalsByStartThenEnd().reversed();
        if (full) {
            TreeMap retVal = new TreeMap(comparator);
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!intervalFilter.test(dataSegment.getInterval())) continue;
                Map segments = retVal.computeIfAbsent(dataSegment.getInterval(), i -> new HashMap());
                Pair<DataSegment, Set<String>> segmentAndServers = this.getServersWhereSegmentIsServed(dataSegment.getId());
                if (segmentAndServers == null) continue;
                segments.put(dataSegment.getId(), ImmutableMap.of((Object)"metadata", (Object)segmentAndServers.lhs, (Object)"servers", (Object)segmentAndServers.rhs));
            }
            return Response.ok(retVal).build();
        }
        TreeMap statsPerInterval = new TreeMap(comparator);
        for (DataSegment dataSegment : dataSource.getSegments()) {
            if (!intervalFilter.test(dataSegment.getInterval())) continue;
            Map properties = statsPerInterval.computeIfAbsent(dataSegment.getInterval(), i -> new EnumMap(SimpleProperties.class));
            properties.merge(SimpleProperties.size, dataSegment.getSize(), (a, b) -> (Long)a + (Long)b);
            properties.merge(SimpleProperties.count, 1, (a, b) -> (Integer)a + (Integer)b);
        }
        return Response.ok(statsPerInterval).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getAllServedSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        Response.ResponseBuilder builder = Response.ok();
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity((Object)Iterables.transform(dataSource.getSegments(), DataSegment::getId)).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getServedSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        for (SegmentId possibleSegmentId : SegmentId.iteratePossibleParsingsWithDataSource((String)dataSourceName, (String)segmentId)) {
            Pair<DataSegment, Set<String>> retVal = this.getServersWhereSegmentIsServed(possibleSegmentId);
            if (retVal == null) continue;
            return Response.ok((Object)ImmutableMap.of((Object)"metadata", (Object)retVal.lhs, (Object)"servers", (Object)retVal.rhs)).build();
        }
        log.warn("Segment id [%s] is unknown", new Object[]{segmentId});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markSegmentAsUnused(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentIdString) {
        SegmentId segmentId = SegmentId.tryParse((String)dataSourceName, (String)segmentIdString);
        boolean segmentStateChanged = segmentId != null && this.segmentsMetadataManager.markSegmentAsUnused(segmentId);
        return Response.ok((Object)ImmutableMap.of((Object)"segmentStateChanged", (Object)segmentStateChanged)).build();
    }

    @POST
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markSegmentAsUsed(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        boolean segmentStateChanged = this.segmentsMetadataManager.markSegmentAsUsed(segmentId);
        return Response.ok().entity((Object)ImmutableMap.of((Object)"segmentStateChanged", (Object)segmentStateChanged)).build();
    }

    @GET
    @Path(value="/{dataSourceName}/tiers")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getTiersWhereSegmentsAreServed(@PathParam(value="dataSourceName") String dataSourceName) {
        HashSet<String> retVal = new HashSet<String>();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            if (druidServer.getDataSource(dataSourceName) == null) continue;
            retVal.add(druidServer.getTier());
        }
        return Response.ok(retVal).build();
    }

    @Nullable
    private ImmutableDruidDataSource getDataSource(String dataSourceName) {
        List dataSources = this.serverInventoryView.getInventory().stream().map(server -> server.getDataSource(dataSourceName)).filter(Objects::nonNull).collect(Collectors.toList());
        if (dataSources.isEmpty()) {
            return null;
        }
        TreeMap<SegmentId, DataSegment> segmentMap = new TreeMap<SegmentId, DataSegment>();
        for (DruidDataSource dataSource : dataSources) {
            Collection<DataSegment> segments = dataSource.getSegments();
            for (DataSegment segment : segments) {
                segmentMap.put(segment.getId(), segment);
            }
        }
        return new ImmutableDruidDataSource(dataSourceName, Collections.emptyMap(), segmentMap);
    }

    @Nullable
    private Pair<DataSegment, Set<String>> getServersWhereSegmentIsServed(SegmentId segmentId) {
        DataSegment theSegment = null;
        HashSet<String> servers = new HashSet<String>();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            DataSegment currSegment = druidServer.getSegment(segmentId);
            if (currSegment == null) continue;
            theSegment = currSegment;
            servers.add(druidServer.getHost());
        }
        if (theSegment == null) {
            return null;
        }
        return new Pair(theSegment, servers);
    }

    private Map<String, Object> makeSimpleDatasource(ImmutableDruidDataSource input) {
        return new ImmutableMap.Builder().put((Object)"name", (Object)input.getName()).put((Object)"properties", this.getSimpleDatasource(input.getName())).build();
    }

    private Map<String, Map<String, Object>> getSimpleDatasource(String dataSourceName) {
        HashMap<String, HashMap<String, Integer>> tiers = new HashMap<String, HashMap<String, Integer>>();
        HashMap<String, Number> segments = new HashMap<String, Number>();
        ImmutableMap retVal = ImmutableMap.of((Object)"tiers", tiers, (Object)"segments", segments);
        HashSet<SegmentId> totalDistinctSegments = new HashSet<SegmentId>();
        HashMap<String, HashSet> tierDistinctSegments = new HashMap<String, HashSet>();
        long totalSegmentSize = 0L;
        long totalReplicatedSize = 0L;
        DateTime minTime = DateTimes.MAX;
        DateTime maxTime = DateTimes.MIN;
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            DruidDataSource druidDataSource = druidServer.getDataSource(dataSourceName);
            String tier = druidServer.getTier();
            if (druidDataSource == null) continue;
            tierDistinctSegments.computeIfAbsent(tier, t -> new HashSet());
            long dataSourceSegmentSize = 0L;
            long replicatedSegmentSize = 0L;
            for (DataSegment dataSegment : druidDataSource.getSegments()) {
                if (!((HashSet)tierDistinctSegments.get(tier)).contains(dataSegment.getId())) {
                    dataSourceSegmentSize += dataSegment.getSize();
                    ((HashSet)tierDistinctSegments.get(tier)).add(dataSegment.getId());
                }
                if (totalDistinctSegments.add(dataSegment.getId())) {
                    totalSegmentSize += dataSegment.getSize();
                    minTime = DateTimes.min((DateTime)minTime, (DateTime)dataSegment.getInterval().getStart());
                    maxTime = DateTimes.max((DateTime)maxTime, (DateTime)dataSegment.getInterval().getEnd());
                }
                totalReplicatedSize += dataSegment.getSize();
                replicatedSegmentSize += dataSegment.getSize();
            }
            HashMap<String, Integer> tierStats = (HashMap<String, Integer>)tiers.get(tier);
            if (tierStats == null) {
                tierStats = new HashMap<String, Integer>();
                tiers.put(druidServer.getTier(), tierStats);
            }
            tierStats.put("segmentCount", ((HashSet)tierDistinctSegments.get(tier)).size());
            long segmentSize = MapUtils.getLong(tierStats, (String)"size", (Long)0L);
            tierStats.put("size", (Integer)(segmentSize + dataSourceSegmentSize));
            long replicatedSize = MapUtils.getLong(tierStats, (String)"replicatedSize", (Long)0L);
            tierStats.put("replicatedSize", (Integer)(replicatedSize + replicatedSegmentSize));
        }
        segments.put("count", totalDistinctSegments.size());
        segments.put("size", totalSegmentSize);
        segments.put("replicatedSize", totalReplicatedSize);
        segments.put("minTime", (Number)minTime);
        segments.put("maxTime", (Number)maxTime);
        return retVal;
    }

    @GET
    @Path(value="/{dataSourceName}/intervals/{interval}/serverview")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getServedSegmentsInInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval, @QueryParam(value="partial") boolean partial) {
        VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.serverInventoryView.getTimeline((DataSource)new TableDataSource(dataSourceName));
        Interval theInterval = Intervals.of((String)interval.replace('_', '/'));
        if (timeline == null) {
            log.debug("No timeline found for datasource[%s]", new Object[]{dataSourceName});
            return Response.ok(new ArrayList()).build();
        }
        return Response.ok(this.prepareServedSegmentsInInterval((TimelineLookup<String, SegmentLoadInfo>)timeline, theInterval)).build();
    }

    private Iterable<ImmutableSegmentLoadInfo> prepareServedSegmentsInInterval(TimelineLookup<String, SegmentLoadInfo> dataSourceServingTimeline, Interval interval) {
        List lookup = dataSourceServingTimeline.lookupWithIncompletePartitions(interval);
        return FunctionalIterable.create((Iterable)lookup).transformCat(input -> Iterables.transform((Iterable)input.getObject(), chunk -> ((SegmentLoadInfo)chunk.getObject()).toImmutableSegmentLoadInfo()));
    }

    @GET
    @Path(value="/{dataSourceName}/handoffComplete")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response isHandOffComplete(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval, @QueryParam(value="partitionNumber") int partitionNumber, @QueryParam(value="version") String version) {
        try {
            List<Rule> rules = this.metadataRuleManager.getRulesWithDefault(dataSourceName);
            Interval theInterval = Intervals.of((String)interval);
            SegmentDescriptor descriptor = new SegmentDescriptor(theInterval, version, partitionNumber);
            DateTime now = DateTimes.nowUtc();
            boolean dropped = true;
            for (Rule rule : rules) {
                if (!rule.appliesTo(theInterval, now)) continue;
                if (!(rule instanceof LoadRule)) break;
                dropped = false;
                break;
            }
            if (dropped) {
                return Response.ok((Object)true).build();
            }
            VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.serverInventoryView.getTimeline((DataSource)new TableDataSource(dataSourceName));
            if (timeline == null) {
                log.debug("No timeline found for datasource[%s]", new Object[]{dataSourceName});
                return Response.ok((Object)false).build();
            }
            Iterable<ImmutableSegmentLoadInfo> servedSegmentsInInterval = this.prepareServedSegmentsInInterval((TimelineLookup<String, SegmentLoadInfo>)timeline, theInterval);
            if (DataSourcesResource.isSegmentLoaded(servedSegmentsInInterval, descriptor)) {
                return Response.ok((Object)true).build();
            }
            return Response.ok((Object)false).build();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error while handling hand off check request", new Object[0]);
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)e.toString())).build();
        }
    }

    static boolean isSegmentLoaded(Iterable<ImmutableSegmentLoadInfo> servedSegments, SegmentDescriptor descriptor) {
        for (ImmutableSegmentLoadInfo segmentLoadInfo : servedSegments) {
            if (!segmentLoadInfo.getSegment().getInterval().contains((ReadableInterval)descriptor.getInterval()) || segmentLoadInfo.getSegment().getShardSpec().getPartitionNum() != descriptor.getPartitionNumber() || segmentLoadInfo.getSegment().getVersion().compareTo(descriptor.getVersion()) < 0 || !Iterables.any(segmentLoadInfo.getServers(), DruidServerMetadata::isSegmentReplicationTarget)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    protected static class MarkDataSourceSegmentsPayload {
        private final Interval interval;
        private final Set<String> segmentIds;

        @JsonCreator
        public MarkDataSourceSegmentsPayload(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="segmentIds") Set<String> segmentIds) {
            this.interval = interval;
            this.segmentIds = segmentIds;
        }

        @JsonProperty
        public Interval getInterval() {
            return this.interval;
        }

        @JsonProperty
        public Set<String> getSegmentIds() {
            return this.segmentIds;
        }

        public boolean isValid() {
            return this.interval == null ^ this.segmentIds == null && (this.segmentIds == null || !this.segmentIds.isEmpty());
        }
    }

    static enum SimpleProperties {
        size,
        count;

    }

    private static class SegmentsLoadStatistics {
        private int numPublishedSegments;
        private int numUnavailableSegments;
        private int numLoadedSegments;

        SegmentsLoadStatistics(int numPublishedSegments, int numUnavailableSegments, int numLoadedSegments) {
            this.numPublishedSegments = numPublishedSegments;
            this.numUnavailableSegments = numUnavailableSegments;
            this.numLoadedSegments = numLoadedSegments;
        }

        public int getNumPublishedSegments() {
            return this.numPublishedSegments;
        }

        public int getNumUnavailableSegments() {
            return this.numUnavailableSegments;
        }

        public int getNumLoadedSegments() {
            return this.numLoadedSegments;
        }
    }

    private static interface MarkSegments {
        public int markSegments() throws UnknownSegmentIdsException;
    }
}

