/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.table.BaseExternTableTest;
import org.apache.druid.catalog.model.table.ExternalTableDefn;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.InputSourceDefn;
import org.apache.druid.catalog.model.table.TableBuilder;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.java.util.common.IAE;
import org.junit.Assert;
import org.junit.Test;

public class InlineInputSourceDefnTest
extends BaseExternTableTest {
    @Test
    public void testValidateEmptyInputSource() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource((Map)ImmutableMap.of((Object)"type", (Object)"inline")).inputFormat(CSV_FORMAT).column("x", Columns.STRING).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testValidateNoFormat() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a\n"))).column("x", Columns.STRING).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testValidateNoColumns() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a\n"))).inputFormat(CSV_FORMAT).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testValidateGood() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a\n"))).inputFormat(CSV_FORMAT).column("x", Columns.STRING).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
    }

    @Test
    public void testFullTableFnBasics() {
        InputSourceDefn defn = this.registry.inputSourceDefnFor("inline");
        TableFunction fn = defn.adHocTableFn();
        Assert.assertNotNull((Object)fn);
        Assert.assertTrue((boolean)this.hasParam(fn, "data"));
        Assert.assertTrue((boolean)this.hasParam(fn, "format"));
        Assert.assertTrue((boolean)this.hasParam(fn, "listDelimiter"));
    }

    @Test
    public void testMissingArgs() {
        InputSourceDefn defn = this.registry.inputSourceDefnFor("inline");
        TableFunction fn = defn.adHocTableFn();
        Assert.assertThrows(IAE.class, () -> fn.apply("x", new HashMap(), Collections.emptyList(), this.mapper));
    }

    @Test
    public void testMissingFormat() {
        InputSourceDefn defn = this.registry.inputSourceDefnFor("inline");
        TableFunction fn = defn.adHocTableFn();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("data", "a");
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, Collections.emptyList(), this.mapper));
    }

    @Test
    public void testValidAdHocFn() {
        InputSourceDefn defn = this.registry.inputSourceDefnFor("inline");
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("data", Arrays.asList("a,b", "c,d"));
        args.put("format", "csv");
        List<ColumnSpec> columns = Arrays.asList(new ColumnSpec("a", Columns.STRING, null), new ColumnSpec("b", Columns.STRING, null));
        TableFunction fn = defn.adHocTableFn();
        ExternalTableSpec extern = fn.apply("x", args, columns, this.mapper);
        Assert.assertTrue((boolean)(extern.inputSource instanceof InlineInputSource));
        InlineInputSource inputSource = (InlineInputSource)extern.inputSource;
        Assert.assertEquals((Object)"a,b\nc,d\n", (Object)inputSource.getData());
        Assert.assertTrue((boolean)(extern.inputFormat instanceof CsvInputFormat));
        CsvInputFormat format = (CsvInputFormat)extern.inputFormat;
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)format.getColumns());
        Assert.assertEquals((long)2L, (long)extern.signature.size());
        Assert.assertEquals(Collections.singleton("inline"), (Object)extern.inputSourceTypesSupplier.get());
        Assert.assertThrows(IAE.class, () -> fn.apply("x", new HashMap(), Collections.emptyList(), this.mapper));
    }

    @Test
    public void testPartialTable() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a,b\nc,d\n"))).inputFormat(CSV_FORMAT).column("a", Columns.STRING).column("b", Columns.STRING).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
        TableFunction fn = ((ExternalTableDefn)resolved.defn()).tableFn(resolved);
        Assert.assertTrue((boolean)fn.parameters().isEmpty());
        ExternalTableSpec extern = fn.apply("x", new HashMap(), Collections.emptyList(), this.mapper);
        Assert.assertTrue((boolean)(extern.inputSource instanceof InlineInputSource));
        InlineInputSource inputSource = (InlineInputSource)extern.inputSource;
        Assert.assertEquals((Object)"a,b\nc,d\n", (Object)inputSource.getData());
        Assert.assertTrue((boolean)(extern.inputFormat instanceof CsvInputFormat));
        CsvInputFormat actualFormat = (CsvInputFormat)extern.inputFormat;
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)actualFormat.getColumns());
        Assert.assertEquals((long)2L, (long)extern.signature.size());
        Assert.assertEquals(Collections.singleton("inline"), (Object)extern.inputSourceTypesSupplier.get());
        List<ColumnSpec> columns = Arrays.asList(new ColumnSpec("a", Columns.STRING, null), new ColumnSpec("b", Columns.STRING, null));
        Assert.assertThrows(IAE.class, () -> fn.apply("x", new HashMap(), columns, this.mapper));
    }

    @Test
    public void testDefinedTable() {
        CsvInputFormat format = new CsvInputFormat(Collections.singletonList("a"), ";", Boolean.valueOf(false), Boolean.valueOf(false), 0);
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a,b\nc,d"))).inputFormat(this.formatToMap((InputFormat)format)).column("a", Columns.STRING).column("b", Columns.STRING).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
        ExternalTableSpec extern = ((ExternalTableDefn)resolved.defn()).convert(resolved);
        Assert.assertTrue((boolean)(extern.inputSource instanceof InlineInputSource));
        InlineInputSource inputSource = (InlineInputSource)extern.inputSource;
        Assert.assertEquals((Object)"a,b\nc,d\n", (Object)inputSource.getData());
        Assert.assertTrue((boolean)(extern.inputFormat instanceof CsvInputFormat));
        CsvInputFormat actualFormat = (CsvInputFormat)extern.inputFormat;
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)actualFormat.getColumns());
        Assert.assertEquals((long)2L, (long)extern.signature.size());
        Assert.assertEquals(Collections.singleton("inline"), (Object)extern.inputSourceTypesSupplier.get());
    }
}

