/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.coordinator;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.coordinator.CoordinatorClientImpl;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.rpc.MockServiceClient;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.DataSourceInformation;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoordinatorClientImplTest {
    private ObjectMapper jsonMapper;
    private MockServiceClient serviceClient;
    private CoordinatorClient coordinatorClient;

    @Before
    public void setup() {
        this.jsonMapper = new DefaultObjectMapper();
        this.jsonMapper.setInjectableValues((InjectableValues)new InjectableValues.Std((Map)ImmutableMap.of((Object)DataSegment.PruneSpecsHolder.class.getName(), (Object)DataSegment.PruneSpecsHolder.DEFAULT)));
        this.serviceClient = new MockServiceClient();
        this.coordinatorClient = new CoordinatorClientImpl((ServiceClient)this.serviceClient, this.jsonMapper);
    }

    @After
    public void tearDown() {
        this.serviceClient.verify();
    }

    @Test
    public void test_isHandoffComplete() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/datasources/xyz/handoffComplete?interval=2000-01-01T00%3A00%3A00.000Z%2F3000-01-01T00%3A00%3A00.000Z&partitionNumber=2&version=1"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), StringUtils.toUtf8((String)"true"));
        Assert.assertEquals((Object)true, (Object)this.coordinatorClient.isHandoffComplete("xyz", new SegmentDescriptor(Intervals.of((String)"2000/3000"), "1", 2)).get());
    }

    @Test
    public void test_fetchUsedSegment() throws Exception {
        DataSegment segment = DataSegment.builder().dataSource("xyz").interval(Intervals.of((String)"2000/3000")).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 1)).size(1L).build();
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/metadata/datasources/xyz/segments/def?includeUnused=false"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)segment));
        Assert.assertEquals((Object)segment, (Object)this.coordinatorClient.fetchSegment("xyz", "def", false).get());
    }

    @Test
    public void test_fetchSegment() throws Exception {
        DataSegment segment = DataSegment.builder().dataSource("xyz").interval(Intervals.of((String)"2000/3000")).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 1)).size(1L).build();
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/metadata/datasources/xyz/segments/def?includeUnused=true"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)segment));
        Assert.assertEquals((Object)segment, (Object)this.coordinatorClient.fetchSegment("xyz", "def", true).get());
    }

    @Test
    public void test_fetchUsedSegments() throws Exception {
        List<Interval> intervals = Collections.singletonList(Intervals.of((String)"2000/3000"));
        DataSegment segment = DataSegment.builder().dataSource("xyz").interval(intervals.get(0)).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 1)).size(1L).build();
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.POST, "/druid/coordinator/v1/metadata/datasources/xyz/segments?full").jsonContent(this.jsonMapper, intervals), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(Collections.singletonList(segment)));
        Assert.assertEquals(Collections.singletonList(segment), (Object)this.coordinatorClient.fetchUsedSegments("xyz", intervals).get());
    }

    @Test
    public void test_fetchDataSourceInformation() throws Exception {
        String foo = "foo";
        DataSourceInformation fooInfo = new DataSourceInformation("foo", RowSignature.builder().add("d1", ColumnType.FLOAT).add("d2", ColumnType.DOUBLE).build());
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.POST, "/druid/coordinator/v1/metadata/dataSourceInformation").jsonContent(this.jsonMapper, Collections.singletonList(foo)), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(Collections.singletonList(fooInfo)));
        Assert.assertEquals(Collections.singletonList(fooInfo), (Object)this.coordinatorClient.fetchDataSourceInformation(Collections.singleton(foo)).get());
    }

    @Test
    public void test_fetchServerViewSegments() throws Exception {
        ImmutableList intervals = ImmutableList.of((Object)Intervals.of((String)"2001/2002"), (Object)Intervals.of((String)"2501/2502"));
        ImmutableSet serverMetadataSet = ImmutableSet.of((Object)new DruidServerMetadata("TEST_SERVER", "testhost:9092", null, 1L, ServerType.INDEXER_EXECUTOR, "tier1", 0));
        ImmutableSegmentLoadInfo immutableSegmentLoadInfo1 = new ImmutableSegmentLoadInfo(DataSegment.builder().dataSource("xyz").interval((Interval)intervals.get(0)).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 1)).size(1L).build(), (Set)serverMetadataSet);
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/datasources/xyz/intervals/2001-01-01T00:00:00.000Z_2002-01-01T00:00:00.000Z/serverview?full"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(Collections.singletonList(immutableSegmentLoadInfo1)));
        ImmutableSegmentLoadInfo immutableSegmentLoadInfo2 = new ImmutableSegmentLoadInfo(DataSegment.builder().dataSource("xyz").interval((Interval)intervals.get(1)).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 1)).size(1L).build(), (Set)serverMetadataSet);
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/datasources/xyz/intervals/2501-01-01T00:00:00.000Z_2502-01-01T00:00:00.000Z/serverview?full"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(Collections.singletonList(immutableSegmentLoadInfo2)));
        ImmutableList segmentLoadInfoList = ImmutableList.of((Object)immutableSegmentLoadInfo1, (Object)immutableSegmentLoadInfo2);
        Assert.assertEquals((Object)segmentLoadInfoList, (Object)this.coordinatorClient.fetchServerViewSegments("xyz", (List)intervals));
    }
}

