/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.client.indexing.ClientCompactionTaskDimensionsSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.junit.Assert;
import org.junit.Test;

public class ClientCompactionTaskDimensionsSpecTest {
    @Test
    public void testEquals() {
        EqualsVerifier.forClass(ClientCompactionTaskDimensionsSpec.class).withPrefabValues(DimensionSchema.class, (Object)new StringDimensionSchema("bar", DimensionSchema.MultiValueHandling.ofDefault(), Boolean.valueOf(true)), (Object)new StringDimensionSchema("foo", DimensionSchema.MultiValueHandling.ofDefault(), Boolean.valueOf(true))).usingGetClass().verify();
    }

    @Test
    public void testSerde() throws IOException {
        ClientCompactionTaskDimensionsSpec expected = new ClientCompactionTaskDimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim")));
        ObjectMapper mapper = new ObjectMapper();
        byte[] json = mapper.writeValueAsBytes((Object)expected);
        ClientCompactionTaskDimensionsSpec fromJson = (ClientCompactionTaskDimensionsSpec)mapper.readValue(json, ClientCompactionTaskDimensionsSpec.class);
        Assert.assertEquals((Object)expected, (Object)fromJson);
    }

    @Test(expected=ParseException.class)
    public void testInvalidDimensionsField() {
        ClientCompactionTaskDimensionsSpec expected = new ClientCompactionTaskDimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim", (Object)"dim")));
    }
}

