/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator.discovery;

import java.util.concurrent.CountDownLatch;
import javax.annotation.Nullable;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.server.DruidNode;

public class LatchableServiceAnnouncer
implements ServiceAnnouncer {
    private final CountDownLatch announceLatch;
    private final CountDownLatch unannounceLatch;

    public LatchableServiceAnnouncer(@Nullable CountDownLatch announceLatch, @Nullable CountDownLatch unannounceLatch) {
        this.announceLatch = announceLatch;
        this.unannounceLatch = unannounceLatch;
    }

    public void announce(DruidNode node) {
        if (this.announceLatch != null) {
            this.announceLatch.countDown();
        }
    }

    public void unannounce(DruidNode node) {
        if (this.unannounceLatch != null) {
            this.unannounceLatch.countDown();
        }
    }
}

