/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.ServerModule;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.ServerType;
import org.junit.Assert;
import org.junit.Test;

public class DiscoveryDruidNodeTest {
    private final DruidNode druidNode = new DruidNode("testNode", "host", true, Integer.valueOf(8082), null, true, false);
    private final NodeRole nodeRole = NodeRole.BROKER;

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(DiscoveryDruidNode.class).withNonnullFields(new String[]{"druidNode", "nodeRole", "services"}).withIgnoredFields(new String[]{"startTime"}).usingGetClass().verify();
    }

    @Test
    public void testDeserialize() throws JsonProcessingException {
        ObjectMapper mapper = DiscoveryDruidNodeTest.createObjectMapper((Collection<Class<? extends DruidService>>)ImmutableList.of(Service1.class, Service2.class));
        DiscoveryDruidNode node = new DiscoveryDruidNode(this.druidNode, this.nodeRole, (Map)ImmutableMap.of((Object)"service1", (Object)((Object)new Service1()), (Object)"service2", (Object)((Object)new Service2())));
        String json = mapper.writeValueAsString((Object)node);
        DiscoveryDruidNode fromJson = (DiscoveryDruidNode)mapper.readValue(json, DiscoveryDruidNode.class);
        Assert.assertEquals((Object)node, (Object)fromJson);
    }

    @Test
    public void testDeserializeIgnorUnknownDruidService() throws JsonProcessingException {
        ObjectMapper mapper = DiscoveryDruidNodeTest.createObjectMapper((Collection<Class<? extends DruidService>>)ImmutableList.of(Service1.class));
        DiscoveryDruidNode node = new DiscoveryDruidNode(this.druidNode, this.nodeRole, (Map)ImmutableMap.of((Object)"service1", (Object)((Object)new Service1()), (Object)"service2", (Object)((Object)new Service2())));
        String json = mapper.writeValueAsString((Object)node);
        DiscoveryDruidNode fromJson = (DiscoveryDruidNode)mapper.readValue(json, DiscoveryDruidNode.class);
        Assert.assertEquals((Object)new DiscoveryDruidNode(this.druidNode, this.nodeRole, (Map)ImmutableMap.of((Object)"service1", (Object)((Object)new Service1()))), (Object)fromJson);
    }

    @Test
    public void testSerdeWithDataNodeAndLookupNodeServices() throws JsonProcessingException {
        ObjectMapper mapper = DiscoveryDruidNodeTest.createObjectMapper((Collection<Class<? extends DruidService>>)ImmutableList.of());
        DiscoveryDruidNode node = new DiscoveryDruidNode(new DruidNode("druid/broker", "druid-broker", false, Integer.valueOf(8082), Integer.valueOf(-1), Integer.valueOf(8282), Boolean.valueOf(true), true), NodeRole.BROKER, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("_default_tier", 1000000000L, ServerType.BROKER, 0), (Object)"lookupNodeService", (Object)new LookupNodeService("lookup_tier")));
        String json = mapper.writeValueAsString((Object)node);
        Assert.assertEquals((Object)node, (Object)mapper.readValue(json, DiscoveryDruidNode.class));
    }

    @Test
    public void testDeserializeWithDataNodeServiceWithAWrongPropertyOrder() throws JsonProcessingException {
        ObjectMapper mapper = DiscoveryDruidNodeTest.createObjectMapper((Collection<Class<? extends DruidService>>)ImmutableList.of());
        String json = "{\n  \"druidNode\" : {\n    \"service\" : \"druid/broker\",\n    \"host\" : \"druid-broker\",\n    \"bindOnHost\" : false,\n    \"plaintextPort\" : 8082,\n    \"port\" : -1,\n    \"tlsPort\" : 8282,\n    \"enablePlaintextPort\" : true,\n    \"enableTlsPort\" : true\n  },\n  \"nodeType\" : \"broker\",\n  \"services\" : {\n    \"dataNodeService\" : {\n      \"type\" : \"broker\",\n      \"type\" : \"dataNodeService\",\n      \"tier\" : \"_default_tier\",\n      \"maxSize\" : 1000000000,\n      \"serverType\" : \"broker\",\n      \"priority\" : 0\n    }\n  }\n}";
        Assert.assertEquals((Object)new DiscoveryDruidNode(new DruidNode("druid/broker", "druid-broker", false, Integer.valueOf(8082), Integer.valueOf(-1), Integer.valueOf(8282), Boolean.valueOf(true), true), NodeRole.BROKER, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("_default_tier", 1000000000L, ServerType.BROKER, 0))), (Object)mapper.readValue("{\n  \"druidNode\" : {\n    \"service\" : \"druid/broker\",\n    \"host\" : \"druid-broker\",\n    \"bindOnHost\" : false,\n    \"plaintextPort\" : 8082,\n    \"port\" : -1,\n    \"tlsPort\" : 8282,\n    \"enablePlaintextPort\" : true,\n    \"enableTlsPort\" : true\n  },\n  \"nodeType\" : \"broker\",\n  \"services\" : {\n    \"dataNodeService\" : {\n      \"type\" : \"broker\",\n      \"type\" : \"dataNodeService\",\n      \"tier\" : \"_default_tier\",\n      \"maxSize\" : 1000000000,\n      \"serverType\" : \"broker\",\n      \"priority\" : 0\n    }\n  }\n}", DiscoveryDruidNode.class));
    }

    @Test
    public void testDeserialize_duplicateProperties_shouldSucceedToDeserialize() throws JsonProcessingException {
        ObjectMapper mapper = DiscoveryDruidNodeTest.createObjectMapper((Collection<Class<? extends DruidService>>)ImmutableList.of());
        String json = "{\n  \"druidNode\" : {\n    \"service\" : \"druid/broker\",\n    \"host\" : \"druid-broker\",\n    \"bindOnHost\" : false,\n    \"plaintextPort\" : 8082,\n    \"port\" : -1,\n    \"tlsPort\" : 8282,\n    \"enablePlaintextPort\" : true,\n    \"enableTlsPort\" : true\n  },\n  \"nodeType\" : \"broker\",\n  \"services\" : {\n    \"dataNodeService\" : {\n      \"type\" : \"dataNodeService\",\n      \"tier\" : \"_default_tier\",\n      \"maxSize\" : 1000000000,\n      \"maxSize\" : 1000000000,\n      \"serverType\" : \"broker\",\n      \"priority\" : 0\n    }\n  }\n}";
        Assert.assertEquals((Object)new DiscoveryDruidNode(new DruidNode("druid/broker", "druid-broker", false, Integer.valueOf(8082), Integer.valueOf(-1), Integer.valueOf(8282), Boolean.valueOf(true), true), NodeRole.BROKER, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("_default_tier", 1000000000L, ServerType.BROKER, 0))), (Object)mapper.readValue("{\n  \"druidNode\" : {\n    \"service\" : \"druid/broker\",\n    \"host\" : \"druid-broker\",\n    \"bindOnHost\" : false,\n    \"plaintextPort\" : 8082,\n    \"port\" : -1,\n    \"tlsPort\" : 8282,\n    \"enablePlaintextPort\" : true,\n    \"enableTlsPort\" : true\n  },\n  \"nodeType\" : \"broker\",\n  \"services\" : {\n    \"dataNodeService\" : {\n      \"type\" : \"dataNodeService\",\n      \"tier\" : \"_default_tier\",\n      \"maxSize\" : 1000000000,\n      \"maxSize\" : 1000000000,\n      \"serverType\" : \"broker\",\n      \"priority\" : 0\n    }\n  }\n}", DiscoveryDruidNode.class));
    }

    @Test
    public void testDeserialize_duplicateKeysWithDifferentValus_shouldIgnoreDataNodeService() throws JsonProcessingException {
        ObjectMapper mapper = DiscoveryDruidNodeTest.createObjectMapper((Collection<Class<? extends DruidService>>)ImmutableList.of());
        String json = "{\n  \"druidNode\" : {\n    \"service\" : \"druid/broker\",\n    \"host\" : \"druid-broker\",\n    \"bindOnHost\" : false,\n    \"plaintextPort\" : 8082,\n    \"port\" : -1,\n    \"tlsPort\" : 8282,\n    \"enablePlaintextPort\" : true,\n    \"enableTlsPort\" : true\n  },\n  \"nodeType\" : \"broker\",\n  \"services\" : {\n    \"dataNodeService\" : {\n      \"type\" : \"dataNodeService\",\n      \"tier\" : \"_default_tier\",\n      \"maxSize\" : 1000000000,\n      \"maxSize\" : 10,\n      \"serverType\" : \"broker\",\n      \"priority\" : 0\n    }\n  }\n}";
        Assert.assertEquals((Object)new DiscoveryDruidNode(new DruidNode("druid/broker", "druid-broker", false, Integer.valueOf(8082), Integer.valueOf(-1), Integer.valueOf(8282), Boolean.valueOf(true), true), NodeRole.BROKER, (Map)ImmutableMap.of()), (Object)mapper.readValue("{\n  \"druidNode\" : {\n    \"service\" : \"druid/broker\",\n    \"host\" : \"druid-broker\",\n    \"bindOnHost\" : false,\n    \"plaintextPort\" : 8082,\n    \"port\" : -1,\n    \"tlsPort\" : 8282,\n    \"enablePlaintextPort\" : true,\n    \"enableTlsPort\" : true\n  },\n  \"nodeType\" : \"broker\",\n  \"services\" : {\n    \"dataNodeService\" : {\n      \"type\" : \"dataNodeService\",\n      \"tier\" : \"_default_tier\",\n      \"maxSize\" : 1000000000,\n      \"maxSize\" : 10,\n      \"serverType\" : \"broker\",\n      \"priority\" : 0\n    }\n  }\n}", DiscoveryDruidNode.class));
    }

    private static ObjectMapper createObjectMapper(Collection<Class<? extends DruidService>> druidServicesToRegister) {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.registerModules((Iterable)new ServerModule().getJacksonModules());
        mapper.registerSubtypes(druidServicesToRegister);
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ObjectMapper.class, (Object)mapper));
        return mapper;
    }

    private static class Service2
    extends DruidService {
        private Service2() {
        }

        public String getName() {
            return "service2";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof Service2;
        }
    }

    private static class Service1
    extends DruidService {
        private Service1() {
        }

        public String getName() {
            return "service1";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof Service1;
        }
    }
}

