/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataRuleManagerConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SQLMetadataRuleManager;
import org.apache.druid.metadata.SQLMetadataSegmentPublisher;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.server.audit.AuditManagerConfig;
import org.apache.druid.server.audit.AuditSerdeHelper;
import org.apache.druid.server.audit.SQLAuditManager;
import org.apache.druid.server.audit.SQLAuditManagerConfig;
import org.apache.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SQLMetadataRuleManagerTest {
    private static final String DATASOURCE = "wiki";
    @org.junit.Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private TestDerbyConnector connector;
    private MetadataStorageTablesConfig tablesConfig;
    private MetadataRuleManagerConfig managerConfig;
    private SQLMetadataRuleManager ruleManager;
    private AuditManager auditManager;
    private SQLMetadataSegmentPublisher publisher;
    private final ObjectMapper mapper = new DefaultObjectMapper();

    @Before
    public void setUp() {
        this.connector = this.derbyConnectorRule.getConnector();
        this.tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.connector.createAuditTable();
        SQLAuditManagerConfig auditManagerConfig = new SQLAuditManagerConfig(null, null, null, null, null);
        this.auditManager = new SQLAuditManager((AuditManagerConfig)auditManagerConfig, new AuditSerdeHelper((AuditManagerConfig)auditManagerConfig, null, this.mapper, this.mapper), (SQLMetadataConnector)this.connector, Suppliers.ofInstance((Object)this.tablesConfig), (ServiceEmitter)new NoopServiceEmitter(), this.mapper);
        this.connector.createRulesTable();
        this.managerConfig = new MetadataRuleManagerConfig();
        this.ruleManager = new SQLMetadataRuleManager(this.mapper, this.managerConfig, this.tablesConfig, (SQLMetadataConnector)this.connector, this.auditManager);
        this.connector.createSegmentTable();
        this.publisher = new SQLMetadataSegmentPublisher(this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.connector);
    }

    @Test
    public void testMultipleStopAndStart() {
        this.ruleManager.start();
        this.ruleManager.stop();
        this.ruleManager.start();
        this.ruleManager.stop();
    }

    @Test
    public void testRuleInsert() {
        List<IntervalLoadRule> rules = Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2), null));
        this.ruleManager.overrideRule(DATASOURCE, rules, this.createAuditInfo("override rule"));
        Map allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get(DATASOURCE)).size());
        Assert.assertEquals((Object)rules.get(0), ((List)allRules.get(DATASOURCE)).get(0));
    }

    @Test
    public void testOverrideRuleWithNull() {
        IAE exception = (IAE)Assert.assertThrows(IAE.class, () -> this.ruleManager.overrideRule(DATASOURCE, null, this.createAuditInfo("null rule")));
        Assert.assertEquals((Object)"Rules cannot be null.", (Object)exception.getMessage());
        exception = (IAE)Assert.assertThrows(IAE.class, () -> this.ruleManager.overrideRule(this.managerConfig.getDefaultRule(), null, this.createAuditInfo("null cluster rule")));
        Assert.assertEquals((Object)"Rules cannot be null.", (Object)exception.getMessage());
    }

    @Test
    public void testOverrideRuleWithEmpty() {
        IAE exception = (IAE)Assert.assertThrows(IAE.class, () -> this.ruleManager.overrideRule(this.managerConfig.getDefaultRule(), Collections.emptyList(), this.createAuditInfo("empty cluster rule")));
        Assert.assertEquals((Object)"Cluster-level rules cannot be empty.", (Object)exception.getMessage());
        Assert.assertTrue((boolean)this.ruleManager.overrideRule(DATASOURCE, Collections.emptyList(), this.createAuditInfo("empty rule")));
    }

    @Test
    public void testAuditEntryCreated() throws Exception {
        List<IntervalLoadRule> rules = Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2), null));
        AuditInfo auditInfo = this.createAuditInfo("create audit entry");
        this.ruleManager.overrideRule(DATASOURCE, rules, auditInfo);
        this.ruleManager.poll();
        Assert.assertEquals(rules, (Object)this.ruleManager.getRules(DATASOURCE));
        List auditEntries = this.auditManager.fetchAuditHistory(DATASOURCE, "rules", null);
        Assert.assertEquals((long)1L, (long)auditEntries.size());
        AuditEntry entry = (AuditEntry)auditEntries.get(0);
        Assert.assertEquals(rules, (Object)this.mapper.readValue(entry.getPayload().serialized(), (TypeReference)new TypeReference<List<Rule>>(){}));
        Assert.assertEquals((Object)auditInfo, (Object)entry.getAuditInfo());
        Assert.assertEquals((Object)DATASOURCE, (Object)entry.getKey());
    }

    @Test
    public void testFetchAuditEntriesForAllDataSources() throws Exception {
        List<IntervalLoadRule> rules = Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2), null));
        AuditInfo auditInfo = this.createAuditInfo("test_comment");
        this.ruleManager.overrideRule(DATASOURCE, rules, auditInfo);
        this.ruleManager.overrideRule("test_dataSource2", rules, auditInfo);
        this.ruleManager.poll();
        Assert.assertEquals(rules, (Object)this.ruleManager.getRules(DATASOURCE));
        Assert.assertEquals(rules, (Object)this.ruleManager.getRules("test_dataSource2"));
        List auditEntries = this.auditManager.fetchAuditHistory("rules", null);
        Assert.assertEquals((long)2L, (long)auditEntries.size());
        for (AuditEntry entry : auditEntries) {
            Assert.assertEquals(rules, (Object)this.mapper.readValue(entry.getPayload().serialized(), (TypeReference)new TypeReference<List<Rule>>(){}));
            Assert.assertEquals((Object)auditInfo, (Object)entry.getAuditInfo());
        }
    }

    @Test
    public void testRemoveRulesOlderThanWithNonExistenceDatasourceAndOlderThanTimestampShouldDelete() {
        ImmutableList rules = ImmutableList.of((Object)new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2), null));
        this.ruleManager.overrideRule(DATASOURCE, (List)rules, this.createAuditInfo("test"));
        this.ruleManager.poll();
        Map allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get(DATASOURCE)).size());
        this.ruleManager.removeRulesForEmptyDatasourcesOlderThan(System.currentTimeMillis());
        this.ruleManager.poll();
        allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)0L, (long)allRules.size());
    }

    @Test
    public void testRemoveRulesOlderThanWithNonExistenceDatasourceAndNewerThanTimestampShouldNotDelete() {
        ImmutableList rules = ImmutableList.of((Object)new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2), null));
        this.ruleManager.overrideRule(DATASOURCE, (List)rules, this.createAuditInfo("update rules"));
        this.ruleManager.poll();
        Map allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get(DATASOURCE)).size());
        this.ruleManager.removeRulesForEmptyDatasourcesOlderThan(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis());
        this.ruleManager.poll();
        allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get(DATASOURCE)).size());
    }

    @Test
    public void testRemoveRulesOlderThanWithActiveDatasourceShouldNotDelete() throws Exception {
        ImmutableList rules = ImmutableList.of((Object)new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2), null));
        this.ruleManager.overrideRule(DATASOURCE, (List)rules, this.createAuditInfo("update rules"));
        this.ruleManager.poll();
        Map allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get(DATASOURCE)).size());
        DataSegment dataSegment = new DataSegment(DATASOURCE, Intervals.of((String)"2015-01-01/2015-02-01"), "1", (Map)ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)"test", (Object)"key", (Object)"test_dataSource/xxx"), (List)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3"), (List)ImmutableList.of((Object)"count", (Object)"value"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(1), 1234L);
        this.publisher.publishSegment(dataSegment);
        this.ruleManager.removeRulesForEmptyDatasourcesOlderThan(System.currentTimeMillis());
        this.ruleManager.poll();
        allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get(DATASOURCE)).size());
    }

    @Test
    public void testRemoveRulesOlderThanShouldNotDeleteDefault() {
        this.ruleManager.start();
        this.ruleManager.poll();
        Map allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get("_default")).size());
        this.ruleManager.removeRulesForEmptyDatasourcesOlderThan(System.currentTimeMillis());
        this.ruleManager.poll();
        allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get("_default")).size());
    }

    @After
    public void cleanup() {
        this.dropTable(this.tablesConfig.getAuditTable());
        this.dropTable(this.tablesConfig.getRulesTable());
    }

    private void dropTable(String tableName) {
        this.connector.getDBI().withHandle(handle -> handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{tableName})).execute());
    }

    private AuditInfo createAuditInfo(String comment) {
        return new AuditInfo("test", "id", comment, "127.0.0.1");
    }
}

