/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.rpc.DiscoveryServiceLocator;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocations;
import org.apache.druid.server.DruidNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class DiscoveryServiceLocatorTest {
    private static final DiscoveryDruidNode NODE1 = new DiscoveryDruidNode(new DruidNode("test-service", "node1.example.com", false, Integer.valueOf(-1), Integer.valueOf(8888), false, true), NodeRole.BROKER, Collections.emptyMap());
    private static final DiscoveryDruidNode NODE2 = new DiscoveryDruidNode(new DruidNode("test-service", "node2.example.com", false, Integer.valueOf(-1), Integer.valueOf(8888), false, true), NodeRole.BROKER, Collections.emptyMap());
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    public DruidNodeDiscoveryProvider discoveryProvider;
    private DiscoveryServiceLocator locator;

    @After
    public void tearDown() {
        if (this.locator != null) {
            this.locator.close();
        }
    }

    @Test
    public void test_locate_initializeEmpty() throws Exception {
        TestDiscovery discovery = new TestDiscovery();
        Mockito.when((Object)this.discoveryProvider.getForNodeRole(NodeRole.BROKER)).thenReturn((Object)discovery);
        this.locator = new DiscoveryServiceLocator(this.discoveryProvider, NodeRole.BROKER);
        this.locator.start();
        ListenableFuture future = this.locator.locate();
        Assert.assertFalse((boolean)future.isDone());
        discovery.fire(DruidNodeDiscovery.Listener::nodeViewInitialized);
        Assert.assertEquals((Object)ServiceLocations.forLocations(Collections.emptySet()), (Object)future.get());
    }

    @Test
    public void test_locate_initializeNonEmpty() throws Exception {
        TestDiscovery discovery = new TestDiscovery();
        Mockito.when((Object)this.discoveryProvider.getForNodeRole(NodeRole.BROKER)).thenReturn((Object)discovery);
        this.locator = new DiscoveryServiceLocator(this.discoveryProvider, NodeRole.BROKER);
        this.locator.start();
        ListenableFuture future = this.locator.locate();
        Assert.assertFalse((boolean)future.isDone());
        discovery.fire(listener -> {
            listener.nodesAdded((Collection)ImmutableSet.of((Object)NODE1));
            listener.nodesAdded((Collection)ImmutableSet.of((Object)NODE2));
            listener.nodeViewInitialized();
        });
        Assert.assertEquals((Object)ServiceLocations.forLocations((Set)ImmutableSet.of((Object)ServiceLocation.fromDruidNode((DruidNode)NODE1.getDruidNode()), (Object)ServiceLocation.fromDruidNode((DruidNode)NODE2.getDruidNode()))), (Object)future.get());
    }

    @Test
    public void test_locate_removeAfterAdd() throws Exception {
        TestDiscovery discovery = new TestDiscovery();
        Mockito.when((Object)this.discoveryProvider.getForNodeRole(NodeRole.BROKER)).thenReturn((Object)discovery);
        this.locator = new DiscoveryServiceLocator(this.discoveryProvider, NodeRole.BROKER);
        this.locator.start();
        discovery.fire(listener -> {
            listener.nodesAdded((Collection)ImmutableSet.of((Object)NODE1));
            listener.nodesAdded((Collection)ImmutableSet.of((Object)NODE2));
            listener.nodeViewInitialized();
            listener.nodesRemoved((Collection)ImmutableSet.of((Object)NODE1));
        });
        Assert.assertEquals((Object)ServiceLocations.forLocations((Set)ImmutableSet.of((Object)ServiceLocation.fromDruidNode((DruidNode)NODE2.getDruidNode()))), (Object)this.locator.locate().get());
    }

    @Test
    public void test_locate_closed() throws Exception {
        TestDiscovery discovery = new TestDiscovery();
        Mockito.when((Object)this.discoveryProvider.getForNodeRole(NodeRole.BROKER)).thenReturn((Object)discovery);
        this.locator = new DiscoveryServiceLocator(this.discoveryProvider, NodeRole.BROKER);
        this.locator.start();
        ListenableFuture future = this.locator.locate();
        this.locator.close();
        Assert.assertEquals((Object)ServiceLocations.closed(), (Object)future.get());
        Assert.assertEquals((Object)ServiceLocations.closed(), (Object)this.locator.locate().get());
        Assert.assertEquals((long)0L, (long)discovery.getListeners().size());
    }

    private static class TestDiscovery
    implements DruidNodeDiscovery {
        @GuardedBy(value="this")
        private final List<DruidNodeDiscovery.Listener> listeners = new ArrayList<DruidNodeDiscovery.Listener>();

        public Collection<DiscoveryDruidNode> getAllNodes() {
            throw new UnsupportedOperationException();
        }

        public synchronized void registerListener(DruidNodeDiscovery.Listener listener) {
            this.listeners.add(listener);
        }

        public synchronized void removeListener(DruidNodeDiscovery.Listener listener) {
            this.listeners.remove(listener);
        }

        public synchronized List<DruidNodeDiscovery.Listener> getListeners() {
            return ImmutableList.copyOf(this.listeners);
        }

        public synchronized void fire(Consumer<DruidNodeDiscovery.Listener> f) {
            for (DruidNodeDiscovery.Listener listener : this.listeners) {
                f.accept(listener);
            }
        }
    }
}

