/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.druid.rpc.FixedSetServiceLocator;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocations;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.junit.Assert;
import org.junit.Test;

public class FixedSetServiceLocatorTest {
    public static final DruidServerMetadata DATA_SERVER_1 = new DruidServerMetadata("TestDataServer", "hostName:9092", null, 2L, ServerType.REALTIME, "tier1", 2);

    @Test
    public void testLocateNullShouldBeClosed() throws ExecutionException, InterruptedException {
        FixedSetServiceLocator serviceLocator = FixedSetServiceLocator.forDruidServerMetadata(null);
        Assert.assertTrue((boolean)((ServiceLocations)serviceLocator.locate().get()).isClosed());
    }

    @Test
    public void testLocateSingleServer() throws ExecutionException, InterruptedException {
        FixedSetServiceLocator serviceLocator = FixedSetServiceLocator.forDruidServerMetadata((Set)ImmutableSet.of((Object)DATA_SERVER_1));
        Assert.assertEquals((Object)ServiceLocations.forLocation((ServiceLocation)ServiceLocation.fromDruidServerMetadata((DruidServerMetadata)DATA_SERVER_1)), (Object)serviceLocator.locate().get());
    }
}

