/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc.indexing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.druid.client.indexing.ClientKillUnusedSegmentsTaskQuery;
import org.apache.druid.client.indexing.ClientTaskQuery;
import org.apache.druid.client.indexing.IndexingTotalWorkerCapacityInfo;
import org.apache.druid.client.indexing.IndexingWorker;
import org.apache.druid.client.indexing.IndexingWorkerInfo;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStatus;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.metadata.LockFilterPolicy;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.rpc.MockServiceClient;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.rpc.indexing.OverlordClientImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OverlordClientImplTest {
    private static final List<TaskStatusPlus> STATUSES = Collections.singletonList(new TaskStatusPlus("taskId", null, null, DateTimes.of((String)"2000"), DateTimes.of((String)"2000"), TaskState.RUNNING, RunnerTaskState.RUNNING, null, TaskLocation.unknown(), null, null));
    private ObjectMapper jsonMapper;
    private MockServiceClient serviceClient;
    private OverlordClient overlordClient;

    @Before
    public void setup() {
        this.jsonMapper = new DefaultObjectMapper();
        this.serviceClient = new MockServiceClient();
        this.overlordClient = new OverlordClientImpl((ServiceClient)this.serviceClient, this.jsonMapper);
    }

    @After
    public void tearDown() {
        this.serviceClient.verify();
    }

    @Test
    public void test_findCurrentLeader() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/leader"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), StringUtils.toUtf8((String)"http://followTheLeader"));
        Assert.assertEquals((Object)URI.create("http://followTheLeader"), (Object)this.overlordClient.findCurrentLeader().get());
    }

    @Test
    public void test_taskStatuses_null_null_null() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/tasks"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(STATUSES));
        Assert.assertEquals(STATUSES, (Object)ImmutableList.copyOf((Iterator)((Iterator)this.overlordClient.taskStatuses(null, null, null).get())));
    }

    @Test
    public void test_taskStatuses_RUNNING_null_null() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/tasks?state=RUNNING"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(STATUSES));
        Assert.assertEquals(STATUSES, (Object)ImmutableList.copyOf((Iterator)((Iterator)this.overlordClient.taskStatuses("RUNNING", null, null).get())));
    }

    @Test
    public void test_taskStatuses_RUNNING_foo_null() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/tasks?state=RUNNING&datasource=foo"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(STATUSES));
        Assert.assertEquals(STATUSES, (Object)ImmutableList.copyOf((Iterator)((Iterator)this.overlordClient.taskStatuses("RUNNING", "foo", null).get())));
    }

    @Test
    public void test_taskStatuses_null_foo_null() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/tasks?datasource=foo"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(STATUSES));
        Assert.assertEquals(STATUSES, (Object)ImmutableList.copyOf((Iterator)((Iterator)this.overlordClient.taskStatuses(null, "foo", null).get())));
    }

    @Test
    public void test_taskStatuses_RUNNING_foo_zero() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/tasks?state=RUNNING&datasource=foo%3F&max=0"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(STATUSES));
        Assert.assertEquals(STATUSES, (Object)ImmutableList.copyOf((Iterator)((Iterator)this.overlordClient.taskStatuses("RUNNING", "foo?", Integer.valueOf(0)).get())));
    }

    @Test
    public void test_taskStatuses_null_null_zero() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/tasks?max=0"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(STATUSES));
        Assert.assertEquals(STATUSES, (Object)ImmutableList.copyOf((Iterator)((Iterator)this.overlordClient.taskStatuses(null, null, Integer.valueOf(0)).get())));
    }

    @Test
    public void test_findLockedIntervals() throws Exception {
        ImmutableMap lockMap = ImmutableMap.of((Object)"foo", Collections.singletonList(Intervals.of((String)"2000/2001")));
        ImmutableList requests = ImmutableList.of((Object)new LockFilterPolicy("foo", 3, null));
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.POST, "/druid/indexer/v1/lockedIntervals/v2").jsonContent(this.jsonMapper, (Object)requests), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)lockMap));
        Assert.assertEquals((Object)lockMap, (Object)this.overlordClient.findLockedIntervals((List)requests).get());
    }

    @Test
    public void test_findLockedIntervals_nullReturn() throws Exception {
        ImmutableList requests = ImmutableList.of((Object)new LockFilterPolicy("foo", 3, null));
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.POST, "/druid/indexer/v1/lockedIntervals/v2").jsonContent(this.jsonMapper, (Object)requests), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(null));
        Assert.assertEquals(Collections.emptyMap(), (Object)this.overlordClient.findLockedIntervals((List)requests).get());
    }

    @Test
    public void test_supervisorStatuses() throws Exception {
        ImmutableList statuses = ImmutableList.of((Object)new SupervisorStatus.Builder().withId("foo").withSource("kafka").withState("chill").build());
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/supervisor?system"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)statuses));
        Assert.assertEquals((Object)statuses, (Object)ImmutableList.copyOf((Iterator)((Iterator)this.overlordClient.supervisorStatuses().get())));
    }

    @Test
    public void test_taskReportAsMap() throws Exception {
        String taskId = "testTaskId";
        ImmutableMap response = ImmutableMap.of((Object)"test", (Object)"value");
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/task/testTaskId/reports"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes((Object)response));
        ListenableFuture future = this.overlordClient.taskReportAsMap("testTaskId");
        Assert.assertEquals((Object)response, (Object)future.get());
    }

    @Test
    public void test_taskReportAsMap_notFound() {
        String taskId = "testTaskId";
        String errorMsg = "No task reports were found for this task. The task may not exist, or it may not have completed yet.";
        this.serviceClient.expectAndThrow(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/task/testTaskId/reports"), (Throwable)new HttpResponseException(new StringFullResponseHolder((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND), StandardCharsets.UTF_8).addChunk(errorMsg)));
        ListenableFuture future = this.overlordClient.taskReportAsMap(taskId);
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> future.get());
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(HttpResponseException.class));
        Assert.assertEquals((long)HttpResponseStatus.NOT_FOUND.getCode(), (long)((HttpResponseException)e.getCause()).getResponse().getStatus().getCode());
    }

    @Test
    public void test_getTaskReport_empty() {
        String taskID = "testTaskId";
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/task/testTaskId/reports"), HttpResponseStatus.OK, Collections.emptyMap(), StringUtils.toUtf8((String)"{}"));
        Map actualResponse = (Map)FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.taskReportAsMap("testTaskId"), (boolean)true);
        Assert.assertEquals(Collections.emptyMap(), (Object)actualResponse);
    }

    @Test
    public void test_getTotalWorkerCapacity() throws Exception {
        int currentClusterCapacity = 5;
        int maximumCapacityWithAutoScale = 10;
        IndexingTotalWorkerCapacityInfo indexingTotalWorkerCapacityInfo = new IndexingTotalWorkerCapacityInfo(currentClusterCapacity, maximumCapacityWithAutoScale);
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/totalWorkerCapacity"), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)indexingTotalWorkerCapacityInfo));
        Assert.assertEquals((Object)indexingTotalWorkerCapacityInfo, (Object)FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.getTotalWorkerCapacity(), (boolean)true));
    }

    @Test
    public void test_getWorkers() throws Exception {
        ImmutableList workers = ImmutableList.of((Object)new IndexingWorkerInfo(new IndexingWorker("http", "localhost", "1.2.3.4", 3, "2"), 0, Collections.emptySet(), Collections.emptyList(), DateTimes.of((String)"2000"), null));
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/workers"), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)workers));
        Assert.assertEquals((Object)workers, (Object)FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.getWorkers(), (boolean)true));
    }

    @Test
    public void test_killPendingSegments() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.DELETE, "/druid/indexer/v1/pendingSegments/foo?interval=2000-01-01T00%3A00%3A00.000Z%2F2001-01-01T00%3A00%3A00.000Z"), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)ImmutableMap.of((Object)"numDeleted", (Object)2L)));
        Assert.assertEquals((Object)2, (Object)FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.killPendingSegments("foo", Intervals.of((String)"2000/2001")), (boolean)true));
    }

    @Test
    public void test_taskPayload() throws ExecutionException, InterruptedException, JsonProcessingException {
        String taskID = "taskId_1";
        ClientKillUnusedSegmentsTaskQuery clientTaskQuery = new ClientKillUnusedSegmentsTaskQuery("taskId_1", "test", null, null, null, null, null);
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/task/taskId_1"), HttpResponseStatus.OK, Collections.emptyMap(), DefaultObjectMapper.INSTANCE.writeValueAsBytes((Object)new TaskPayloadResponse("taskId_1", (ClientTaskQuery)clientTaskQuery)));
        Assert.assertEquals((Object)clientTaskQuery, (Object)((TaskPayloadResponse)this.overlordClient.taskPayload("taskId_1").get()).getPayload());
    }
}

