/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.multibindings.MapBinder;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.OmniDataSegmentKiller;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public class OmniDataSegmentKillerTest {
    @Test
    public void testKillSegmentWithType() throws SegmentLoadingException {
        DataSegmentKiller killer = (DataSegmentKiller)Mockito.mock(DataSegmentKiller.class);
        DataSegment segment = (DataSegment)Mockito.mock(DataSegment.class);
        Mockito.when((Object)segment.isTombstone()).thenReturn((Object)false);
        Mockito.when((Object)segment.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"sane"));
        Injector injector = OmniDataSegmentKillerTest.createInjector(killer);
        OmniDataSegmentKiller segmentKiller = (OmniDataSegmentKiller)injector.getInstance(OmniDataSegmentKiller.class);
        segmentKiller.kill(segment);
        ((DataSegmentKiller)Mockito.verify((Object)killer, (VerificationMode)Mockito.times((int)1))).kill(segment);
    }

    @Test
    public void testKillSegmentUnknowType() {
        DataSegment segment = (DataSegment)Mockito.mock(DataSegment.class);
        Mockito.when((Object)segment.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"unknown-type"));
        Injector injector = OmniDataSegmentKillerTest.createInjector(null);
        OmniDataSegmentKiller segmentKiller = (OmniDataSegmentKiller)injector.getInstance(OmniDataSegmentKiller.class);
        Assert.assertThrows((String)"Unknown loader type[unknown-type]. Known types are [explode]", SegmentLoadingException.class, () -> segmentKiller.kill(segment));
    }

    @Test
    public void testBadSegmentKillerAccessException() {
        DataSegment segment = (DataSegment)Mockito.mock(DataSegment.class);
        Mockito.when((Object)segment.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"bad"));
        Injector injector = OmniDataSegmentKillerTest.createInjector(null);
        OmniDataSegmentKiller segmentKiller = (OmniDataSegmentKiller)injector.getInstance(OmniDataSegmentKiller.class);
        Assert.assertThrows((String)"BadSegmentKiller must not have been initialized", RuntimeException.class, () -> segmentKiller.kill(segment));
    }

    private static Injector createInjector(@Nullable DataSegmentKiller killer) {
        return GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> {
            MapBinder mapBinder = Binders.dataSegmentKillerBinder((Binder)binder);
            if (killer != null) {
                mapBinder.addBinding((Object)"sane").toInstance((Object)killer);
            }
        }, binder -> {
            MapBinder mapBinder = Binders.dataSegmentKillerBinder((Binder)binder);
            mapBinder.addBinding((Object)"bad").to(BadSegmentKiller.class);
        }));
    }

    private static Injector createInjectorFromMap(@NotNull Map<String, DataSegmentKiller> killerMap) {
        ImmutableList.Builder moduleListBuilder = ImmutableList.builder();
        for (Map.Entry<String, DataSegmentKiller> typeToKiller : killerMap.entrySet()) {
            moduleListBuilder.add(binder -> {
                MapBinder mapBinder = Binders.dataSegmentKillerBinder((Binder)binder);
                mapBinder.addBinding((Object)((String)typeToKiller.getKey())).toInstance((Object)((DataSegmentKiller)typeToKiller.getValue()));
            });
        }
        return GuiceInjectors.makeStartupInjectorWithModules((Iterable)moduleListBuilder.build());
    }

    @Test
    public void testKillTombstone() throws Exception {
        DataSegment tombstone = DataSegment.builder().dataSource("test").interval(Intervals.of((String)"2021-01-01/P1D")).version("version").size(1L).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"tombstone", (Object)"path", (Object)"null")).shardSpec((ShardSpec)new TombstoneShardSpec()).build();
        Injector injector = OmniDataSegmentKillerTest.createInjector(null);
        OmniDataSegmentKiller segmentKiller = (OmniDataSegmentKiller)injector.getInstance(OmniDataSegmentKiller.class);
        segmentKiller.kill(tombstone);
    }

    @Test
    public void testKillMultipleSegmentsWithType() throws SegmentLoadingException {
        DataSegmentKiller killerSane = (DataSegmentKiller)Mockito.mock(DataSegmentKiller.class);
        DataSegmentKiller killerSaneTwo = (DataSegmentKiller)Mockito.mock(DataSegmentKiller.class);
        DataSegment segment1 = (DataSegment)Mockito.mock(DataSegment.class);
        DataSegment segment2 = (DataSegment)Mockito.mock(DataSegment.class);
        DataSegment segment3 = (DataSegment)Mockito.mock(DataSegment.class);
        Mockito.when((Object)segment1.isTombstone()).thenReturn((Object)false);
        Mockito.when((Object)segment1.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"sane"));
        Mockito.when((Object)segment2.isTombstone()).thenReturn((Object)false);
        Mockito.when((Object)segment2.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"sane"));
        Mockito.when((Object)segment3.isTombstone()).thenReturn((Object)false);
        Mockito.when((Object)segment3.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"sane_2"));
        Injector injector = OmniDataSegmentKillerTest.createInjectorFromMap((Map<String, DataSegmentKiller>)ImmutableMap.of((Object)"sane", (Object)killerSane, (Object)"sane_2", (Object)killerSaneTwo));
        OmniDataSegmentKiller segmentKiller = (OmniDataSegmentKiller)injector.getInstance(OmniDataSegmentKiller.class);
        segmentKiller.kill((List)ImmutableList.of((Object)segment1, (Object)segment2, (Object)segment3));
        ((DataSegmentKiller)Mockito.verify((Object)killerSane, (VerificationMode)Mockito.times((int)1))).kill((List)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new DataSegment[]{segment1, segment2})));
        ((DataSegmentKiller)Mockito.verify((Object)killerSaneTwo, (VerificationMode)Mockito.times((int)1))).kill((List)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])new DataSegment[]{segment3})));
    }

    @LazySingleton
    private static class BadSegmentKiller
    implements DataSegmentKiller {
        @Inject
        BadSegmentKiller() {
            throw new RuntimeException("BadSegmentKiller must not have been initialized");
        }

        public void kill(DataSegment segment) {
        }

        public void killAll() {
        }
    }
}

