/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BySegmentQueryRunner;
import org.apache.druid.query.DirectQueryProcessingPool;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.metadata.SegmentMetadataQuerySegmentWalker;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.timeline.DataSegment;

public class TestSegmentMetadataQueryWalker
extends SegmentMetadataQuerySegmentWalker {
    private QueryRunnerFactoryConglomerate conglomerate;
    private Map<SegmentDescriptor, Pair<QueryableIndex, DataSegment>> queryableIndexMap;

    public TestSegmentMetadataQueryWalker(CoordinatorServerView serverView, DruidHttpClientConfig httpClientConfig, QueryToolChestWarehouse warehouse, ServerConfig serverConfig, ServiceEmitter emitter, QueryRunnerFactoryConglomerate conglomerate, Map<SegmentDescriptor, Pair<QueryableIndex, DataSegment>> queryableIndexMap) {
        super(serverView, httpClientConfig, warehouse, serverConfig, emitter);
        this.conglomerate = conglomerate;
        this.queryableIndexMap = queryableIndexMap;
    }

    public void add(DataSegment segment, QueryableIndex index) {
        this.queryableIndexMap.put(segment.toDescriptor(), (Pair<QueryableIndex, DataSegment>)Pair.of((Object)index, (Object)segment));
    }

    <T> Sequence getServerResults(QueryRunner serverRunner, QueryPlus<T> queryPlus, ResponseContext responseContext, long maxQueuedBytesPerServer, List<SegmentDescriptor> segmentDescriptors) {
        QueryRunnerFactory factory = this.conglomerate.findFactory(queryPlus.getQuery());
        QueryToolChest toolChest = factory.getToolchest();
        return new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, (Iterable)FunctionalIterable.create(segmentDescriptors).transform(segment -> new BySegmentQueryRunner(((DataSegment)this.queryableIndexMap.get((Object)segment).rhs).getId(), ((DataSegment)this.queryableIndexMap.get((Object)segment).rhs).getInterval().getStart(), factory.createRunner((Segment)new QueryableIndexSegment((QueryableIndex)this.queryableIndexMap.get((Object)segment).lhs, ((DataSegment)this.queryableIndexMap.get((Object)segment).rhs).getId())))))), toolChest).run(queryPlus, responseContext);
    }

    public List<DataSegment> getSegments() {
        return this.queryableIndexMap.values().stream().map(pair -> (DataSegment)pair.rhs).collect(Collectors.toList());
    }
}

