/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Random;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.RealtimeIOConfig;
import org.apache.druid.segment.realtime.FireDepartment;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.RealtimeMetricsMonitor;
import org.junit.Before;
import org.junit.Test;

public class RealtimeMetricsMonitorTest {
    private StubServiceEmitter emitter;
    private Random random;

    @Before
    public void setup() {
        this.random = new Random(100L);
        this.emitter = new StubServiceEmitter("test", "localhost");
    }

    @Test
    public void testDoMonitor() {
        FireDepartment fireDepartment = new FireDepartment(new DataSchema("wiki", null, null, null, null, null, null, (ObjectMapper)new DefaultObjectMapper()), new RealtimeIOConfig(null, null), null);
        FireDepartmentMetrics metrics = fireDepartment.getMetrics();
        this.invokeRandomTimes(() -> ((FireDepartmentMetrics)metrics).incrementThrownAway());
        this.invokeRandomTimes(() -> ((FireDepartmentMetrics)metrics).incrementUnparseable());
        this.invokeRandomTimes(() -> ((FireDepartmentMetrics)metrics).incrementProcessed());
        this.invokeRandomTimes(() -> ((FireDepartmentMetrics)metrics).incrementDedup());
        this.invokeRandomTimes(() -> ((FireDepartmentMetrics)metrics).incrementFailedHandoffs());
        this.invokeRandomTimes(() -> ((FireDepartmentMetrics)metrics).incrementFailedPersists());
        this.invokeRandomTimes(() -> ((FireDepartmentMetrics)metrics).incrementHandOffCount());
        this.invokeRandomTimes(() -> ((FireDepartmentMetrics)metrics).incrementNumPersists());
        metrics.incrementPushedRows((long)this.random.nextInt());
        metrics.incrementRowOutputCount((long)this.random.nextInt());
        metrics.incrementMergedRows((long)this.random.nextInt());
        metrics.incrementMergeCpuTime((long)this.random.nextInt());
        metrics.setSinkCount((long)this.random.nextInt());
        RealtimeMetricsMonitor monitor = new RealtimeMetricsMonitor(Collections.singletonList(fireDepartment));
        monitor.doMonitor((ServiceEmitter)this.emitter);
        this.emitter.verifyValue("ingest/events/thrownAway", (Number)metrics.thrownAway());
        this.emitter.verifyValue("ingest/events/unparseable", (Number)metrics.unparseable());
        this.emitter.verifyValue("ingest/events/duplicate", (Number)metrics.dedup());
        this.emitter.verifyValue("ingest/events/processed", (Number)metrics.processed());
        this.emitter.verifyValue("ingest/rows/output", (Number)metrics.rowOutput());
        this.emitter.verifyValue("ingest/persists/count", (Number)metrics.numPersists());
        this.emitter.verifyValue("ingest/persists/time", (Number)metrics.persistTimeMillis());
        this.emitter.verifyValue("ingest/persists/cpu", (Number)metrics.persistCpuTime());
        this.emitter.verifyValue("ingest/persists/backPressure", (Number)metrics.persistBackPressureMillis());
        this.emitter.verifyValue("ingest/persists/failed", (Number)metrics.failedPersists());
        this.emitter.verifyValue("ingest/handoff/failed", (Number)metrics.failedHandoffs());
        this.emitter.verifyValue("ingest/merge/time", (Number)metrics.mergeTimeMillis());
        this.emitter.verifyValue("ingest/merge/cpu", (Number)metrics.mergeCpuTime());
        this.emitter.verifyValue("ingest/handoff/count", (Number)metrics.handOffCount());
        this.emitter.verifyValue("ingest/sink/count", (Number)metrics.sinkCount());
    }

    private void invokeRandomTimes(Action action) {
        int limit = this.random.nextInt(20);
        for (int i = 0; i < limit; ++i) {
            action.perform();
        }
    }

    @FunctionalInterface
    private static interface Action {
        public void perform();
    }
}

