/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.PartitionChunk;

public class TestUsedSegmentChecker
implements UsedSegmentChecker {
    private final List<DataSegment> pushedSegments;

    public TestUsedSegmentChecker(List<DataSegment> pushedSegments) {
        this.pushedSegments = pushedSegments;
    }

    public Set<DataSegment> findUsedSegments(Set<SegmentIdWithShardSpec> identifiers) {
        SegmentTimeline timeline = SegmentTimeline.forSegments(this.pushedSegments);
        HashSet<DataSegment> retVal = new HashSet<DataSegment>();
        for (SegmentIdWithShardSpec identifier : identifiers) {
            for (TimelineObjectHolder holder : timeline.lookup(identifier.getInterval())) {
                for (PartitionChunk chunk : holder.getObject()) {
                    if (!identifiers.contains(SegmentIdWithShardSpec.fromDataSegment((DataSegment)((DataSegment)chunk.getObject())))) continue;
                    retVal.add((DataSegment)chunk.getObject());
                }
            }
        }
        return retVal;
    }
}

