/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BrokerParallelMergeConfig;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.DefaultQueryRunnerFactoryConglomerate;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.query.TestBufferPool;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.TestGroupByBuffers;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.query.operator.WindowOperatorQueryQueryRunnerFactory;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanQueryRunnerFactory;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryQueryRunnerFactory;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.join.FrameBasedInlineJoinableFactory;
import org.apache.druid.segment.join.InlineJoinableFactory;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.join.LookupJoinableFactory;
import org.apache.druid.segment.join.MapJoinableFactory;
import org.apache.druid.server.ClientQuerySegmentWalker;
import org.apache.druid.server.LocalQuerySegmentWalker;
import org.apache.druid.server.QueryLaningStrategy;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.SubqueryGuardrailHelper;
import org.apache.druid.server.TestClusterQuerySegmentWalker;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.metrics.SubqueryCountStatsProvider;
import org.apache.druid.server.scheduling.ManualQueryPrioritizationStrategy;
import org.apache.druid.server.scheduling.NoQueryLaningStrategy;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.utils.JvmUtils;
import org.junit.Assert;

public class QueryStackTests {
    public static final QueryScheduler DEFAULT_NOOP_SCHEDULER = new QueryScheduler(0, ManualQueryPrioritizationStrategy.INSTANCE, (QueryLaningStrategy)NoQueryLaningStrategy.INSTANCE, new ServerConfig());
    public static final int DEFAULT_NUM_MERGE_BUFFERS = -1;
    private static final ServiceEmitter EMITTER = new NoopServiceEmitter();
    private static final int COMPUTE_BUFFER_SIZE = 0xA00000;

    private QueryStackTests() {
    }

    public static ClientQuerySegmentWalker createClientQuerySegmentWalker(QuerySegmentWalker clusterWalker, QuerySegmentWalker localWalker, final QueryRunnerFactoryConglomerate conglomerate, JoinableFactory joinableFactory, ServerConfig serverConfig) {
        return new ClientQuerySegmentWalker(EMITTER, clusterWalker, localWalker, new QueryToolChestWarehouse(){

            public <T, QueryType extends Query<T>> QueryToolChest<T, QueryType> getToolChest(QueryType query) {
                return conglomerate.findFactory(query).getToolchest();
            }
        }, joinableFactory, new RetryQueryRunnerConfig(), TestHelper.makeJsonMapper(), serverConfig, null, new CacheConfig(){

            public boolean isPopulateCache() {
                return false;
            }

            public boolean isUseCache() {
                return false;
            }

            public boolean isPopulateResultLevelCache() {
                return false;
            }

            public boolean isUseResultLevelCache() {
                return false;
            }
        }, new SubqueryGuardrailHelper(null, JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes(), 1), new SubqueryCountStatsProvider());
    }

    public static TestClusterQuerySegmentWalker createClusterQuerySegmentWalker(Map<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>> timelines, QueryRunnerFactoryConglomerate conglomerate, @Nullable QueryScheduler scheduler) {
        return new TestClusterQuerySegmentWalker(timelines, conglomerate, scheduler);
    }

    public static LocalQuerySegmentWalker createLocalQuerySegmentWalker(QueryRunnerFactoryConglomerate conglomerate, SegmentWrangler segmentWrangler, JoinableFactoryWrapper joinableFactoryWrapper, QueryScheduler scheduler) {
        return new LocalQuerySegmentWalker(conglomerate, segmentWrangler, joinableFactoryWrapper, scheduler, EMITTER);
    }

    public static BrokerParallelMergeConfig getParallelMergeConfig(final boolean useParallelMergePoolConfigured) {
        return new BrokerParallelMergeConfig(){

            public boolean useParallelMergePool() {
                return useParallelMergePoolConfigured;
            }
        };
    }

    public static DruidProcessingConfig getProcessingConfig(final int mergeBuffers) {
        return new DruidProcessingConfig(){

            public String getFormatString() {
                return null;
            }

            public int intermediateComputeSizeBytes() {
                return 0xA00000;
            }

            public int getNumThreads() {
                return 1;
            }

            public int getNumMergeBuffers() {
                if (mergeBuffers == -1) {
                    return 2;
                }
                return mergeBuffers;
            }
        };
    }

    public static QueryRunnerFactoryConglomerate createQueryRunnerFactoryConglomerate(Closer closer) {
        return QueryStackTests.createQueryRunnerFactoryConglomerate(closer, () -> 1000);
    }

    public static QueryRunnerFactoryConglomerate createQueryRunnerFactoryConglomerate(Closer closer, Supplier<Integer> minTopNThresholdSupplier) {
        return QueryStackTests.createQueryRunnerFactoryConglomerate(closer, QueryStackTests.getProcessingConfig(-1), minTopNThresholdSupplier);
    }

    public static QueryRunnerFactoryConglomerate createQueryRunnerFactoryConglomerate(Closer closer, DruidProcessingConfig processingConfig) {
        return QueryStackTests.createQueryRunnerFactoryConglomerate(closer, processingConfig, () -> 1000);
    }

    public static QueryRunnerFactoryConglomerate createQueryRunnerFactoryConglomerate(Closer closer, DruidProcessingConfig processingConfig, final Supplier<Integer> minTopNThresholdSupplier) {
        TestBufferPool testBufferPool = TestBufferPool.offHeap((int)0xA00000, (int)Integer.MAX_VALUE);
        closer.register(() -> Assert.assertEquals((long)0L, (long)testBufferPool.getOutstandingObjectCount()));
        TestGroupByBuffers groupByBuffers = (TestGroupByBuffers)closer.register((Closeable)TestGroupByBuffers.createFromProcessingConfig((DruidProcessingConfig)processingConfig));
        GroupByQueryRunnerFactory groupByQueryRunnerFactory = GroupByQueryRunnerTest.makeQueryRunnerFactory((ObjectMapper)GroupByQueryRunnerTest.DEFAULT_MAPPER, (GroupByQueryConfig)new GroupByQueryConfig(){}, (TestGroupByBuffers)groupByBuffers, (DruidProcessingConfig)processingConfig);
        DefaultQueryRunnerFactoryConglomerate conglomerate = new DefaultQueryRunnerFactoryConglomerate((Map)ImmutableMap.builder().put(SegmentMetadataQuery.class, (Object)new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig("P1W")), QueryRunnerTestHelper.NOOP_QUERYWATCHER)).put(ScanQuery.class, (Object)new ScanQueryRunnerFactory(new ScanQueryQueryToolChest(new ScanQueryConfig(), (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory()), new ScanQueryEngine(), new ScanQueryConfig())).put(TimeseriesQuery.class, (Object)new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER)).put(TopNQuery.class, (Object)new TopNQueryRunnerFactory((NonBlockingPool)testBufferPool, new TopNQueryQueryToolChest(new TopNQueryConfig(){

            public int getMinTopNThreshold() {
                return (Integer)minTopNThresholdSupplier.get();
            }
        }), QueryRunnerTestHelper.NOOP_QUERYWATCHER)).put(GroupByQuery.class, (Object)groupByQueryRunnerFactory).put(TimeBoundaryQuery.class, (Object)new TimeBoundaryQueryRunnerFactory(QueryRunnerTestHelper.NOOP_QUERYWATCHER)).put(WindowOperatorQuery.class, (Object)new WindowOperatorQueryQueryRunnerFactory()).build());
        return conglomerate;
    }

    public static JoinableFactory makeJoinableFactoryForLookup(LookupExtractorFactoryContainerProvider lookupProvider) {
        return QueryStackTests.makeJoinableFactoryFromDefault(lookupProvider, null, null);
    }

    public static JoinableFactory makeJoinableFactoryFromDefault(@Nullable LookupExtractorFactoryContainerProvider lookupProvider, @Nullable Set<JoinableFactory> customFactories, @Nullable Map<Class<? extends JoinableFactory>, Class<? extends DataSource>> customMappings) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        setBuilder.add((Object[])new JoinableFactory[]{new InlineJoinableFactory(), new FrameBasedInlineJoinableFactory()});
        mapBuilder.put(InlineJoinableFactory.class, InlineDataSource.class);
        mapBuilder.put(FrameBasedInlineJoinableFactory.class, FrameBasedInlineDataSource.class);
        if (lookupProvider != null) {
            setBuilder.add((Object)new LookupJoinableFactory(lookupProvider));
            mapBuilder.put(LookupJoinableFactory.class, LookupDataSource.class);
        }
        if (customFactories != null) {
            setBuilder.addAll(customFactories);
        }
        if (customMappings != null) {
            mapBuilder.putAll(customMappings);
        }
        return new MapJoinableFactory((Set)setBuilder.build(), (Map)mapBuilder.build());
    }
}

