/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.server.QueryStats;
import org.apache.druid.server.RequestLogLine;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RequestLogLineTest {
    private Query query;

    @Before
    public void setUp() {
        this.query = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, null, null, null);
    }

    @Test(expected=NullPointerException.class)
    public void nullTimestamp() {
        RequestLogLine requestLogLine = RequestLogLine.forNative((Query)this.query, null, (String)"", (QueryStats)new QueryStats((Map)ImmutableMap.of()));
    }

    @Test(expected=NullPointerException.class)
    public void nullQueryStats() {
        RequestLogLine requestLogLine = RequestLogLine.forNative((Query)this.query, (DateTime)DateTimes.nowUtc(), (String)"", null);
    }

    @Test
    public void nullRemoteAddressAndNullSqlQueryContext() throws JsonProcessingException {
        RequestLogLine requestLogLine = RequestLogLine.forNative((Query)this.query, (DateTime)DateTimes.nowUtc(), null, (QueryStats)new QueryStats((Map)ImmutableMap.of()));
        Assert.assertEquals((Object)"", (Object)requestLogLine.getRemoteAddr());
        requestLogLine.getNativeQueryLine((ObjectMapper)new DefaultObjectMapper());
        requestLogLine = RequestLogLine.forSql((String)"", null, (DateTime)DateTimes.nowUtc(), null, (QueryStats)new QueryStats((Map)ImmutableMap.of()));
        Assert.assertEquals((Object)"", (Object)requestLogLine.getRemoteAddr());
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)requestLogLine.getSqlQueryContext());
        requestLogLine.getSqlQueryLine((ObjectMapper)new DefaultObjectMapper());
    }
}

