/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.segment.FrameBasedInlineSegmentWrangler;
import org.apache.druid.segment.InlineSegmentWrangler;
import org.apache.druid.segment.LookupSegmentWrangler;
import org.apache.druid.segment.MapSegmentWrangler;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;

public class SpecificSegmentsQuerySegmentWalker
implements QuerySegmentWalker,
Closeable {
    private final QuerySegmentWalker walker;
    private final Map<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>> timelines = new HashMap<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>>();
    private final List<Closeable> closeables = new ArrayList<Closeable>();
    private final List<DataSegment> segments = new ArrayList<DataSegment>();
    private static final LookupExtractorFactoryContainerProvider LOOKUP_EXTRACTOR_FACTORY_CONTAINER_PROVIDER = new LookupExtractorFactoryContainerProvider(){

        public Set<String> getAllLookupNames() {
            return Collections.emptySet();
        }

        public Optional<LookupExtractorFactoryContainer> get(String lookupName) {
            return Optional.empty();
        }
    };

    public SpecificSegmentsQuerySegmentWalker(QueryRunnerFactoryConglomerate conglomerate, SegmentWrangler segmentWrangler, JoinableFactoryWrapper joinableFactoryWrapper, QueryScheduler scheduler) {
        this.walker = QueryStackTests.createClientQuerySegmentWalker(QueryStackTests.createClusterQuerySegmentWalker(this.timelines, conglomerate, scheduler), (QuerySegmentWalker)QueryStackTests.createLocalQuerySegmentWalker(conglomerate, segmentWrangler, joinableFactoryWrapper, scheduler), conglomerate, joinableFactoryWrapper.getJoinableFactory(), new ServerConfig());
    }

    public SpecificSegmentsQuerySegmentWalker(QueryRunnerFactoryConglomerate conglomerate) {
        this(conglomerate, (SegmentWrangler)new MapSegmentWrangler((Map)ImmutableMap.builder().put(InlineDataSource.class, (Object)new InlineSegmentWrangler()).put(FrameBasedInlineDataSource.class, (Object)new FrameBasedInlineSegmentWrangler()).put(LookupDataSource.class, (Object)new LookupSegmentWrangler(LOOKUP_EXTRACTOR_FACTORY_CONTAINER_PROVIDER)).build()), new JoinableFactoryWrapper(QueryStackTests.makeJoinableFactoryForLookup(LOOKUP_EXTRACTOR_FACTORY_CONTAINER_PROVIDER)), QueryStackTests.DEFAULT_NOOP_SCHEDULER);
    }

    public SpecificSegmentsQuerySegmentWalker add(DataSegment descriptor, Segment segment) {
        ReferenceCountingSegment referenceCountingSegment = ReferenceCountingSegment.wrapSegment((Segment)segment, (ShardSpec)descriptor.getShardSpec());
        VersionedIntervalTimeline timeline = this.timelines.computeIfAbsent(descriptor.getDataSource(), datasource -> new VersionedIntervalTimeline((Comparator)Ordering.natural()));
        timeline.add(descriptor.getInterval(), (Object)descriptor.getVersion(), descriptor.getShardSpec().createChunk((Object)referenceCountingSegment));
        this.segments.add(descriptor);
        this.closeables.add((Closeable)referenceCountingSegment);
        return this;
    }

    public SpecificSegmentsQuerySegmentWalker add(DataSegment descriptor, QueryableIndex index) {
        return this.add(descriptor, (Segment)new QueryableIndexSegment(index, descriptor.getId()));
    }

    public List<DataSegment> getSegments() {
        return this.segments;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return this.walker.getQueryRunnerForIntervals(query, intervals);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        return this.walker.getQueryRunnerForSegments(query, specs);
    }

    @Override
    public void close() throws IOException {
        for (Closeable closeable : this.closeables) {
            Closeables.close((Closeable)closeable, (boolean)true);
        }
    }
}

