/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Scope;
import com.google.inject.name.Names;
import com.sun.jersey.api.container.grizzly2.GrizzlyServerFactory;
import com.sun.jersey.api.core.ClassNamesResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.guice.spi.container.GuiceComponentProviderFactory;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.annotations.Client;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.server.initialization.jetty.DruidGuiceContainer;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.apache.druid.server.security.AuthorizerMapper;
import org.easymock.EasyMock;
import org.glassfish.grizzly.http.server.HttpServer;

public class WebserverTestUtils {
    public static URI createBaseUri() {
        int port = ThreadLocalRandom.current().nextInt(1024, 65534);
        return UriBuilder.fromUri((String)"http://localhost/").port(port).build(new Object[0]);
    }

    public static HttpServer createServer(String SERVICE_NAME, URI baseUri, String resourceClassName, Consumer<Binder> extender) throws IOException {
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of(binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to(SERVICE_NAME);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(baseUri.getPort());
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(baseUri.getPort() + 1);
            binder.bind(Key.get(ServiceEmitter.class)).toInstance((Object)new NoopServiceEmitter());
            binder.bind(Key.get(AuthConfig.class)).toInstance((Object)new AuthConfig());
            binder.bind(AuthorizerMapper.class).toInstance((Object)AuthTestUtils.TEST_AUTHORIZER_MAPPER);
            binder.bind(AuthenticatorMapper.class).toInstance((Object)AuthTestUtils.TEST_AUTHENTICATOR_MAPPER);
            binder.bind(Key.get(HttpClient.class, Client.class)).toInstance((Object)((HttpClient)EasyMock.createMock(HttpClient.class)));
            extender.accept(binder);
        }));
        ClassNamesResourceConfig resourceConfig = new ClassNamesResourceConfig(new String[]{resourceClassName + ';' + MockHttpServletRequest.class.getName()});
        GuiceComponentProviderFactory ioc = new GuiceComponentProviderFactory((ResourceConfig)resourceConfig, injector){

            public Map<Scope, ComponentScope> createScopeMap() {
                return DruidGuiceContainer.populateScopeMap((Map)super.createScopeMap());
            }
        };
        return GrizzlyServerFactory.createHttpServer((URI)baseUri, (ResourceConfig)resourceConfig, (IoCComponentProviderFactory)ioc);
    }

    @Provider
    public static class MockHttpServletRequest
    extends SingletonTypeInjectableProvider<Context, HttpServletRequest> {
        public MockHttpServletRequest() {
            super(HttpServletRequest.class, (Object)MockHttpServletRequest.createMockRequest());
        }

        static HttpServletRequest createMockRequest() {
            HttpServletRequest mockRequest = (HttpServletRequest)EasyMock.createNiceMock(HttpServletRequest.class);
            AuthenticationResult authenticationResult = new AuthenticationResult("druid", "druid", null, Collections.emptyMap());
            EasyMock.expect((Object)mockRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
            EasyMock.expect((Object)mockRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).anyTimes();
            EasyMock.replay((Object[])new Object[]{mockRequest});
            return mockRequest;
        }
    }
}

