/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.audit;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import java.util.Properties;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.server.audit.AuditLogger;
import org.apache.druid.server.audit.AuditManagerConfig;
import org.apache.druid.server.audit.LoggingAuditManagerConfig;
import org.apache.druid.server.audit.SQLAuditManagerConfig;
import org.junit.Assert;
import org.junit.Test;

public class AuditManagerConfigTest {
    private static final String CONFIG_BASE = "druid.audit.manager";

    @Test
    public void testDefaultAuditConfig() {
        Injector injector = this.createInjector();
        JsonConfigProvider provider = JsonConfigProvider.of((String)CONFIG_BASE, AuditManagerConfig.class);
        provider.inject(new Properties(), (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        AuditManagerConfig config = (AuditManagerConfig)provider.get();
        Assert.assertTrue((boolean)(config instanceof SQLAuditManagerConfig));
        SQLAuditManagerConfig sqlAuditConfig = (SQLAuditManagerConfig)config;
        Assert.assertTrue((boolean)sqlAuditConfig.isAuditSystemRequests());
        Assert.assertFalse((boolean)sqlAuditConfig.isSkipNullField());
        Assert.assertFalse((boolean)sqlAuditConfig.isIncludePayloadAsDimensionInMetric());
        Assert.assertEquals((long)-1L, (long)sqlAuditConfig.getMaxPayloadSizeBytes());
        Assert.assertEquals((long)604800000L, (long)sqlAuditConfig.getAuditHistoryMillis());
    }

    @Test
    public void testLogAuditConfigWithDefaults() {
        Injector injector = this.createInjector();
        JsonConfigProvider provider = JsonConfigProvider.of((String)CONFIG_BASE, AuditManagerConfig.class);
        Properties props = new Properties();
        props.setProperty("druid.audit.manager.type", "log");
        provider.inject(props, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        AuditManagerConfig config = (AuditManagerConfig)provider.get();
        Assert.assertTrue((boolean)(config instanceof LoggingAuditManagerConfig));
        LoggingAuditManagerConfig logAuditConfig = (LoggingAuditManagerConfig)config;
        Assert.assertTrue((boolean)logAuditConfig.isAuditSystemRequests());
        Assert.assertFalse((boolean)logAuditConfig.isSkipNullField());
        Assert.assertEquals((long)-1L, (long)logAuditConfig.getMaxPayloadSizeBytes());
        Assert.assertEquals((Object)AuditLogger.Level.INFO, (Object)logAuditConfig.getLogLevel());
    }

    @Test
    public void testLogAuditConfigWithOverrides() {
        Injector injector = this.createInjector();
        JsonConfigProvider provider = JsonConfigProvider.of((String)CONFIG_BASE, AuditManagerConfig.class);
        Properties props = new Properties();
        props.setProperty("druid.audit.manager.type", "log");
        props.setProperty("druid.audit.manager.logLevel", "WARN");
        props.setProperty("druid.audit.manager.auditSystemRequests", "true");
        provider.inject(props, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        AuditManagerConfig config = (AuditManagerConfig)provider.get();
        Assert.assertTrue((boolean)(config instanceof LoggingAuditManagerConfig));
        LoggingAuditManagerConfig logAuditConfig = (LoggingAuditManagerConfig)config;
        Assert.assertTrue((boolean)logAuditConfig.isAuditSystemRequests());
        Assert.assertFalse((boolean)logAuditConfig.isSkipNullField());
        Assert.assertEquals((long)-1L, (long)logAuditConfig.getMaxPayloadSizeBytes());
        Assert.assertEquals((Object)AuditLogger.Level.WARN, (Object)logAuditConfig.getLogLevel());
    }

    @Test
    public void testSqlAuditConfigWithOverrides() {
        Injector injector = this.createInjector();
        JsonConfigProvider provider = JsonConfigProvider.of((String)CONFIG_BASE, AuditManagerConfig.class);
        Properties props = new Properties();
        props.setProperty("druid.audit.manager.type", "sql");
        props.setProperty("druid.audit.manager.skipNullField", "true");
        props.setProperty("druid.audit.manager.maxPayloadSizeBytes", "100");
        props.setProperty("druid.audit.manager.auditHistoryMillis", "1000");
        props.setProperty("druid.audit.manager.includePayloadAsDimensionInMetric", "true");
        provider.inject(props, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        AuditManagerConfig config = (AuditManagerConfig)provider.get();
        Assert.assertTrue((boolean)(config instanceof SQLAuditManagerConfig));
        SQLAuditManagerConfig sqlAuditConfig = (SQLAuditManagerConfig)config;
        Assert.assertTrue((boolean)sqlAuditConfig.isSkipNullField());
        Assert.assertTrue((boolean)sqlAuditConfig.isIncludePayloadAsDimensionInMetric());
        Assert.assertEquals((long)100L, (long)sqlAuditConfig.getMaxPayloadSizeBytes());
        Assert.assertEquals((long)1000L, (long)sqlAuditConfig.getAuditHistoryMillis());
    }

    private Injector createInjector() {
        return GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> JsonConfigProvider.bind((Binder)binder, (String)CONFIG_BASE, AuditManagerConfig.class)));
    }
}

