/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.curator.CuratorTestBase;
import org.apache.druid.guice.ServerTypeConfig;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.ServerTestHelper;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.SegmentChangeRequestDrop;
import org.apache.druid.server.coordination.SegmentChangeRequestLoad;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordination.ZkCoordinator;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.zookeeper.CreateMode;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ZkCoordinatorTest
extends CuratorTestBase {
    private static final Logger log = new Logger(ZkCoordinatorTest.class);
    private final ObjectMapper jsonMapper = ServerTestHelper.MAPPER;
    private final DruidServerMetadata me = new DruidServerMetadata("dummyServer", "dummyHost", null, 0L, ServerType.HISTORICAL, "normal", 0);
    private final ZkPathsConfig zkPaths = new ZkPathsConfig(){

        public String getBase() {
            return "/druid";
        }
    };
    private ZkCoordinator zkCoordinator;
    private File infoDir;
    private List<StorageLocationConfig> locations;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        try {
            this.infoDir = this.temporaryFolder.newFolder();
            log.info("Creating tmp test files in [%s]", new Object[]{this.infoDir});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.locations = Collections.singletonList(new StorageLocationConfig(this.infoDir, 100L, Double.valueOf(100.0)));
        this.setupServerAndCurator();
        this.curator.start();
        this.curator.blockUntilConnected();
    }

    @After
    public void tearDown() {
        this.tearDownServerAndCurator();
    }

    @Test(timeout=60000L)
    public void testLoadDrop() throws Exception {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        final DataSegment segment = new DataSegment("test", Intervals.of((String)"P1d/2011-04-02"), "v0", (Map)ImmutableMap.of((Object)"version", (Object)"v0", (Object)"interval", (Object)Intervals.of((String)"P1d/2011-04-02"), (Object)"cacheDir", (Object)"/no"), Arrays.asList("dim1", "dim2", "dim3"), Arrays.asList("metric1", "metric2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 123L);
        final CountDownLatch loadLatch = new CountDownLatch(1);
        final CountDownLatch dropLatch = new CountDownLatch(1);
        SegmentLoadDropHandler segmentLoadDropHandler = new SegmentLoadDropHandler(ServerTestHelper.MAPPER, new SegmentLoaderConfig(){

            public File getInfoDir() {
                return ZkCoordinatorTest.this.infoDir;
            }

            public int getNumLoadingThreads() {
                return 5;
            }

            public int getAnnounceIntervalMillis() {
                return 50;
            }

            public List<StorageLocationConfig> getLocations() {
                return ZkCoordinatorTest.this.locations;
            }

            public int getDropSegmentDelayMillis() {
                return 0;
            }
        }, (DataSegmentAnnouncer)EasyMock.createNiceMock(DataSegmentAnnouncer.class), (DataSegmentServerAnnouncer)EasyMock.createNiceMock(DataSegmentServerAnnouncer.class), (SegmentManager)EasyMock.createNiceMock(SegmentManager.class), (SegmentCacheManager)EasyMock.createNiceMock(SegmentCacheManager.class), (ScheduledExecutorService)EasyMock.createNiceMock(ScheduledExecutorService.class), new ServerTypeConfig(ServerType.HISTORICAL)){

            public void addSegment(DataSegment s, DataSegmentChangeCallback callback) {
                if (segment.getId().equals((Object)s.getId())) {
                    loadLatch.countDown();
                    callback.execute();
                }
            }

            public void removeSegment(DataSegment s, DataSegmentChangeCallback callback) {
                if (segment.getId().equals((Object)s.getId())) {
                    dropLatch.countDown();
                    callback.execute();
                }
            }
        };
        this.zkCoordinator = new ZkCoordinator(segmentLoadDropHandler, this.jsonMapper, this.zkPaths, this.me, this.curator, new SegmentLoaderConfig());
        this.zkCoordinator.start();
        String segmentZkPath = ZKPaths.makePath((String)this.zkPaths.getLoadQueuePath(), (String)this.me.getName(), (String[])new String[]{segment.getId().toString()});
        ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(segmentZkPath, this.jsonMapper.writeValueAsBytes((Object)new SegmentChangeRequestLoad(segment)));
        loadLatch.await();
        while (this.curator.checkExists().forPath(segmentZkPath) != null) {
            Thread.sleep(100L);
        }
        ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(segmentZkPath, this.jsonMapper.writeValueAsBytes((Object)new SegmentChangeRequestDrop(segment)));
        dropLatch.await();
        while (this.curator.checkExists().forPath(segmentZkPath) != null) {
            Thread.sleep(100L);
        }
        this.zkCoordinator.stop();
    }
}

